/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web;

import com.google.common.base.Preconditions;
import com.lexicalscope.jewel.cli.ArgumentValidationException;
import com.lexicalscope.jewel.cli.CliFactory;
import java.io.File;
import net.myrrix.online.AbstractRescorerProvider;
import net.myrrix.online.RescorerProvider;
import net.myrrix.web.AllUtilityArgs;

public final class AllConfig {
    private final File localInputDir;
    private final RescorerProvider rescorerProvider;
    private final int howMany;
    private final boolean parallel;
    private final File outFile;

    public AllConfig(File localInputDir, File outFile, RescorerProvider rescorerProvider, int howMany) {
        this(localInputDir, outFile, rescorerProvider, howMany, true);
    }

    public AllConfig(File localInputDir, File outFile, RescorerProvider rescorerProvider, int howMany, boolean parallel) {
        Preconditions.checkNotNull(localInputDir);
        Preconditions.checkArgument(localInputDir.exists() && localInputDir.isDirectory());
        Preconditions.checkNotNull(outFile);
        Preconditions.checkArgument(howMany > 0, "howMany must be positive: %s", howMany);
        this.localInputDir = localInputDir;
        this.rescorerProvider = rescorerProvider;
        this.howMany = howMany;
        this.parallel = parallel;
        this.outFile = outFile;
    }

    public File getLocalInputDir() {
        return this.localInputDir;
    }

    public RescorerProvider getRescorerProvider() {
        return this.rescorerProvider;
    }

    public int getHowMany() {
        return this.howMany;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public File getOutFile() {
        return this.outFile;
    }

    static AllConfig build(String[] args) {
        AllUtilityArgs allArgs;
        try {
            allArgs = CliFactory.parseArguments(AllUtilityArgs.class, args);
        }
        catch (ArgumentValidationException ave) {
            System.out.println();
            System.out.println(ave.getMessage());
            System.out.println();
            return null;
        }
        String rescorerProviderClassNames = allArgs.getRescorerProviderClass();
        RescorerProvider rescorerProvider = rescorerProviderClassNames == null ? null : AbstractRescorerProvider.loadRescorerProviders(rescorerProviderClassNames, null);
        return new AllConfig(allArgs.getLocalInputDir(), allArgs.getOutFile(), rescorerProvider, allArgs.getHowMany(), allArgs.isParallel());
    }
}

