/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.example.rescorer;

import net.myrrix.common.MyrrixRecommender;
import net.myrrix.online.AbstractRescorerProvider;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.Rescorer;
import org.apache.mahout.common.LongPair;

public final class FilterHalfRescorerProvider
extends AbstractRescorerProvider {
    @Override
    public IDRescorer getRecommendRescorer(final long[] userIDs, MyrrixRecommender recommender, String ... args) {
        final boolean odd = args.length > 0 && "odd".equalsIgnoreCase(args[0]);
        return new IDRescorer(){

            @Override
            public double rescore(long itemID, double score) {
                for (long userID : userIDs) {
                    if (odd != ((userID & 1L) == 1L)) continue;
                    return Double.NaN;
                }
                return this.isFiltered(itemID) ? Double.NaN : 10.0 * score;
            }

            @Override
            public boolean isFiltered(long itemID) {
                return odd == ((itemID & 1L) == 1L);
            }
        };
    }

    @Override
    public IDRescorer getRecommendToAnonymousRescorer(final long[] itemIDs, MyrrixRecommender recommender, String ... args) {
        final boolean odd = args.length > 0 && "odd".equalsIgnoreCase(args[0]);
        return new IDRescorer(){

            @Override
            public double rescore(long itemID, double score) {
                for (long anItemID : itemIDs) {
                    if (odd != ((anItemID & 1L) == 1L)) continue;
                    return Double.NaN;
                }
                return this.isFiltered(itemID) ? Double.NaN : 10.0 * score;
            }

            @Override
            public boolean isFiltered(long itemID) {
                return odd == ((itemID & 1L) == 1L);
            }
        };
    }

    @Override
    public IDRescorer getMostPopularItemsRescorer(MyrrixRecommender recommender, String ... args) {
        final boolean odd = args.length > 0 && "odd".equalsIgnoreCase(args[0]);
        return new IDRescorer(){

            @Override
            public double rescore(long itemID, double score) {
                return this.isFiltered(itemID) ? Double.NaN : 10.0 * score;
            }

            @Override
            public boolean isFiltered(long itemID) {
                return odd == ((itemID & 1L) == 1L);
            }
        };
    }

    @Override
    public Rescorer<LongPair> getMostSimilarItemsRescorer(MyrrixRecommender recommender, String ... args) {
        final boolean odd = args.length > 0 && Boolean.valueOf(args[0]) != false;
        return new Rescorer<LongPair>(){

            @Override
            public double rescore(LongPair longPair, double score) {
                return this.isFiltered(longPair) ? Double.NaN : 10.0 * score;
            }

            @Override
            public boolean isFiltered(LongPair longPair) {
                return odd == ((longPair.getFirst() & 1L) == 1L) || odd == ((longPair.getSecond() & 1L) == 1L);
            }
        };
    }
}

