% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commutators.R
\name{indx_Commutator_Mixing}
\alias{indx_Commutator_Mixing}
\title{Index commutator mixing}
\usage{
indx_Commutator_Mixing(x, d1, d2)
}
\arguments{
\item{x}{a vector of dimension \code{prod(d1)*prod(d2)}}

\item{d1}{dimension of the first group of vectors}

\item{d2}{dimension of the second group of vectors}
}
\value{
A vector Kx.
}
\description{
Provides the product Kx where K is the moment commutator as produced by 
\code{matr_Commutator_Mixing} and x is a vector. It avoids the construction of large
commutators matrices working much faster with respect to \code{matr_Commutator_Moment}.
}
\examples{
d1 <- c(2, 3, 2)
d2<-  c(3 ,2, 2)
x<-1:(prod(d1)*prod(d2))
indx_Commutator_Mixing(x,d1,d2)
# Same as
MCM<-matr_Commutator_Mixing(d1,d2)
as.vector(MCM\%*\%x)
}
\references{
Gy.Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021. Formula (4.58) p. 218.
}
\seealso{
Other Matrices and commutators: 
\code{\link{indx_Commutator_Kmn}()},
\code{\link{indx_Commutator_Kperm}()},
\code{\link{indx_Commutator_Moment}()},
\code{\link{indx_Elimination}()},
\code{\link{indx_Qplication}()},
\code{\link{indx_Symmetry}()},
\code{\link{indx_UnivMomCum}()},
\code{\link{matr_Commutator_Kmn}()},
\code{\link{matr_Commutator_Kperm}()},
\code{\link{matr_Commutator_Mixing}()},
\code{\link{matr_Commutator_Moment}()},
\code{\link{matr_Elimination}()},
\code{\link{matr_Qplication}()},
\code{\link{matr_Symmetry}()}
}
\concept{Matrices and commutators}
