% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commutators.R
\name{indx_Qplication}
\alias{indx_Qplication}
\title{Qplication vector}
\usage{
indx_Qplication(xelim, d, q)
}
\arguments{
\item{xelim}{the T-product vector with distinct elements}

\item{d}{dimension of the vectors in the T-product}

\item{q}{power of the Kronecker product}
}
\value{
A vector (T-vector) with all elements previously eliminated by indx_Elimination
}
\description{
Restores the duplicated/q-plicated  elements which are eliminated
by  matr_Elimination or indx_Elimination in a T-product of vectors of dimension d.
It produces the same results as matr_Qplication.
}
\examples{
x<-c(1,2,3)
y<-kronecker(kronecker(x,x),x)
## Distinct elements of y
z<-y[indx_Elimination(3,3)]
## Restore eliminated elements in z
indx_Qplication(z,3,3)

}
\references{
Gy. Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021, p.21, (1.31)
}
\seealso{
Other Matrices and commutators: 
\code{\link{indx_Commutator_Kmn}()},
\code{\link{indx_Commutator_Kperm}()},
\code{\link{indx_Elimination}()},
\code{\link{indx_Symmetry}()},
\code{\link{indx_UnivMomCum}()},
\code{\link{matr_Commutator_Kmn}()},
\code{\link{matr_Commutator_Kperm}()},
\code{\link{matr_Commutator_Mixing}()},
\code{\link{matr_Commutator_Moment}()},
\code{\link{matr_Elimination}()},
\code{\link{matr_Qplication}()},
\code{\link{matr_Symmetry}()}
}
\concept{Matrices and commutators}
