% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult_Set_Functions.R
\name{mult__inv}
\alias{mult__inv}
\title{Inverts an array of matrices so that:  inva[,,i] = inv(a[,,i])}
\usage{
mult__inv(a, whichoutput, nargout)
}
\arguments{
\item{a}{matrix array (N x N x T)}

\item{whichoutput}{if = 'lobabsdet' computes the log(abs(det(a))) only (text).}

\item{nargout}{"nargout == 1" or "nargout == 2"(scalar)}
}
\value{
"nargout == 1" returns inva -> matrix array: a^(-1) (N x N x T) \cr
       "nargout == 2" returns inva -> matrix array: a^(-1) (N x N x T) and  logabsdet ->  vector of log(abs(det(a)))  (1 x T)
}
\description{
Inverts an array of matrices so that:  inva[,,i] = inv(a[,,i])
}
\references{
This function is modified version of the "mult__inv" function by Le and Singleton (2018).\cr
 "A Small Package of Matlab Routines for the Estimation of Some Term Structure Models."\cr
 (Euro Area Business Cycle Network Training School - Term Structure Modelling).
 Available at: https://cepr.org/40029
}
\keyword{internal}
