% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ListModelInputs.R
\name{ListModelInputs}
\alias{ListModelInputs}
\title{Concatenate the model-specific inputs in a list}
\usage{
ListModelInputs(
  ModelType,
  Data = NULL,
  Economies,
  VARXtype = NULL,
  t_First_Wgvar = NULL,
  t_Last_Wgvar = NULL,
  W_type = NULL,
  DomUnit = NULL,
  WishSigmas = NULL,
  SigmaNonOrtho = NULL,
  BiasCorrection = 0,
  flag_mean = NULL,
  gamma = NULL,
  N_iter = NULL,
  N_burn = NULL,
  B = NULL,
  checkBRW = NULL,
  B_check = NULL,
  DataPathTrade = NULL
)
}
\arguments{
\item{ModelType}{string-vector containing the label of the model to be estimated}

\item{Data}{dataset generated from the "DataForEstimation" function}

\item{Economies}{string-vector containing the names of the economies of the system}

\item{VARXtype}{string-vector containing the VARX feature (see "GVAR" function) (GVAR-based models)}

\item{t_First_Wgvar}{Sample starting date (year) (GVAR-based models)}

\item{t_Last_Wgvar}{Sample last date (year) (GVAR-based models)}

\item{W_type}{Criterion used in the computation of the star variables (see "Transition_Matrix" function)
(GVAR-based models)}

\item{DomUnit}{name of the economy which is assigned as the dominant unit (JLL-based models)}

\item{WishSigmas}{equal to "1" if one wishes the variance-covariance matrices and the Cholesky factorizations (JLL-based models)}

\item{SigmaNonOrtho}{NULL or some F x F matrix from the non-orthogonalized dynamics (JLL-based models)}

\item{BiasCorrection}{binary variable. it takes value equal to 1 if the user whishes the estimates to be bias-corrected
and 0, otherwise. (BRW model)}

\item{flag_mean}{flag whether mean- (TRUE) or median- (FALSE) unbiased estimation is desired}

\item{gamma}{adjustment parameter (BRW model)}

\item{N_iter}{number of iterations (BRW model)}

\item{N_burn}{number of burn-in iterations (BRW model)}

\item{B}{number of bootstrap samples (BRW model)}

\item{checkBRW}{flag whether the user wishes to perform the closeness check (BRW model)}

\item{B_check}{number of bootstrap samples for closeness check}

\item{DataPathTrade}{path of the Excel file containing the data (if any)}
}
\description{
Concatenate the model-specific inputs in a list
}
\examples{

ModelType <- "JLL original"
Eco <- c("China","Brazil","Mexico", "Uruguay")
DU <- "China"
Sig <- 1
NonOrtho <- 0


ListModelInputs(ModelType, Economies= Eco, DomUnit = DU, WishSigmas = Sig, SigmaNonOrtho= NonOrtho)


}
