% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_with_vectorized_parameters.R
\name{aux2true}
\alias{aux2true}
\title{Map auxiliary (unconstrained) parameters a to constrained parameters b}
\usage{
aux2true(
  a,
  ctype,
  lb,
  ub,
  FactorLabels,
  Economies,
  JLLinputs = NULL,
  GVARinputs = NULL,
  nargout
)
}
\arguments{
\item{a}{unconstrained auxiliary parameter}

\item{ctype}{One of the following options:
\itemize{
\item 'Jordan'
\item 'Jordan; stationary'
\item 'Jordan MultiCountry'
\item 'Jordan MultiCountry; stationary'
\item 'psd';
\item 'BlockDiag'
\item 'bounded'
\item 'diag'
\item 'JLLstructure'
}}

\item{lb}{lower bounds of b (if option 'bounded' is chosen)}

\item{ub}{upper bounds of b (if option 'bounded' is chosen)}

\item{FactorLabels}{string-list based which contains the labels of all the variables present in the model}

\item{Economies}{string-vector containing the names of the economies which are part of the economic system}

\item{JLLinputs}{Inputs used in the estimation of the JLL-based models}

\item{GVARinputs}{Inputs used in the estimation of the GVAR-based models}

\item{nargout}{"nargout <- 1" returns a constrained scalar or matrix \cr
"nargout <- 2" returns a list of parameters}
}
\description{
Map auxiliary (unconstrained) parameters a to constrained parameters b
}
\references{
This function is a modified version of the "aux2true" function by Le and Singleton (2018). \cr
"A Small Package of Matlab Routines for the Estimation of Some Term Structure Models." \cr
(Euro Area Business Cycle Network Training School - Term Structure Modelling).
Available at: https://cepr.org/40029
}
