% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstruct.R
\name{reconstruct}
\alias{reconstruct}
\title{Apply a clustering algorithm to a given time course.}
\usage{
reconstruct(
  readouts,
  targetCommunities,
  method = "kmedoids",
  sim = MultIS::getSimilarityMatrix(readouts = readouts, upper = TRUE),
  clusterObj = FALSE
)
}
\arguments{
\item{readouts}{The time course for which to find clusters.}

\item{targetCommunities}{The number of clusters to cluster for.}

\item{method}{Either "kmedoids", "kmeans" or any string permitted as a method for stats::hclust.}

\item{sim}{A similarity matrix used with all methods except "kmeans".}

\item{clusterObj}{If TRUE, a clusterObject with the readouts, similarity and clustering is returned.}
}
\value{
A matrix with two columns: "Clone" and "Barcode" or if clusterObj = TRUE a cluster object, which can be used to plot the clustering.
}
\description{
Apply a clustering algorithm to a given time course.
}
