`tTable` <-
function (model, ...) 	UseMethod("tTable")

`tTable.default` <-
function(model, ...) return(summary(model)$coefficients)

`tTable.gam` <-
function(model, ...) {
	cf <- model$coefficients
	se <- summary(model)$se
    return(cbind(`Estimate`=cf, `Std. Error` = se))
}

`tTable.gls` <-
function (model, ...) return(summary(model)$tTable)

`tTable.lme` <-
function(model, ...) return(summary(model)$tTable)


# these are for old versions of lme4
`tTable.mer` <-
#`tTable.glmer` <-
# `tTable.lmer` <-
function(model, ...) {
	#sm <- eval(expression(summary), as.environment("package:lme4"))
	sm <- eval(expression(summary), asNamespace("lme4"))
	return (sm(model)@coefs)
	#return((summary(model))@coefs)
}

`tTable.sarlm` <-
`tTable.spautolm` <-
function(model, ...) {
	cf <- coef(model)
	se <- sqrt(diag(summary(model)$resvar))[names(cf)]
	return(cbind(`Estimate`=cf, `Std. Error` = se))
}


`tTable.multinom` <-
function(model, ...) {
	ret <- do.call("cbind", summary(model)[c("coefficients", "standard.errors")])
	colnames(ret) <- c("Estimate", "Std. Error")
	return(ret)
}

`tTable.coxph` <- function (model, ...)
	return(summary(model)$coefficients[,-c(2, 3), drop=FALSE])
