% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ring_modify.R
\name{ring_modify}
\alias{ring_modify}
\title{Edit ring borders visually}
\usage{
ring_modify(ring.data, del = NULL, del.u = NULL, del.l = NULL,
  add = FALSE)
}
\arguments{
\item{ring.data}{A matrix or array produced by \code{\link{ring_detect}}.}

\item{del}{A numeric vector giving the border numbers to be removed.}

\item{del.u}{A numeric vector giving the border numbers to be removed 
on the upper path.}

\item{del.l}{A numeric vector giving the border numbers to be removed 
on the lower path.}

\item{add}{A logical value indicating whether to add new ring borders.}
}
\value{
A matrix (grayscale image) or array (color image)
representing the tree ring image.
}
\description{
This function can remove existing ring borders 
or add new borders.
}
\details{
This function is used to remove existing ring borders, or to add new 
borders by interactively clicking on the image segments.

If the user creates one path (\code{incline = FALSE}), the argument 
\code{del} is used to remove ring borders. If the user creates two paths 
(\code{incline = TRUE}), arguments \code{del.u} and \code{del.l} are used 
to remove ring borders.

If \code{add = TRUE}, graphics windows opened by \code{\link{ring_detect}}
will be activated sequentially. When a graphics window is activated, 
the user can add new borders by left-clicking the mouse along the path.
Every click draws a point representing the ring border.
Type \code{vignette('detection-MtreeRing')} to see 
an example of adding ring borders.

The identification process does not automatically stop by itself.

\itemize{
  \item
  On the Windows system, the identification process can be terminated by 
  pressing the right mouse button and selecting \bold{Stop} from the menu.
  \item 
  On the MacOS system, for a X11 device the identification process is 
  terminated by pressing any mouse button other than the first, and for a 
  quartz device this process is terminated by pressing the \bold{ESC} key.
}

Once the user terminates the identification process, the current 
graphics window will be closed automatically, and the graphics window of
the following segment is activated. When all graphics windows are closed,
\code{ring_modify} will re-open graphics windows and plot new borders.

This function can perform both deletion and addition in one call.
The removal of ring borders takes precedence over addition.
}
\examples{
img.path <- system.file("001.png", package = "MtreeRing")

## Read a tree ring image:
t1 <- ring_read(img = img.path, dpi = 1200)

## Split a long core sample into 3 pieces to
## get better display performance and use the
## watershed algorithm to detect ring borders:
t2 <- ring_detect(ring.data = t1, seg = 3, method = 'watershed')

## Do not modify t2, but create a new array object t3. 
## Remove some borders without adding new borders:
t3 <- ring_modify(ring.data = t2, del = c(1, 3, 5, 19:21), add = FALSE)

}
\author{
Jingning Shi
}
