% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{tracks}
\alias{as.tracks}
\alias{as.tracks.list}
\alias{c.tracks}
\alias{is.tracks}
\alias{tracks}
\title{Tracks Objects}
\usage{
as.tracks(x, ...)

\method{as.tracks}{list}(x, ...)

is.tracks(x)

\method{c}{tracks}(...)

tracks(...)
}
\arguments{
\item{x}{an object to be coerced or tested.}

\item{...}{for \code{tracks}, numeric matrices or objects that can be coerced to 
 numeric matrices. Each
 matrix contains the data of one track. The first column is the time, and the remaining
 columns define a spatial position. Every given matrix has to contain the same number
 of columns, and at least two columns are necessary.

 For \code{c}, tracks objects to be combined.

 For \code{as.tracks}, further arguments passed to methods (currently not used).}
}
\description{
The function \code{tracks} is used to create tracks objects. \code{as.tracks} coerces
its argument to a tracks object, and \code{is.tracks} tests for tracks objects.
\code{c} can be used to combine (concatenate) tracks objects.
}
\details{
Tracks objects are lists of matrices. Each matrix contains at least two 
columns; the first column is time, and the remaining columns are a spatial coordinate.
The following naming conventions are used (and enforced by \code{tracks}): The time
column has the name `t`, and spatial coordinate columns have names `x`,`y`,`z` if there
are three or less coordinates, and `x1`,...,`xk` if there are \eqn{k \ge 4} 
coordinates. All tracks in an object must have the same number of dimensions. The
positions in a track are expected to be sorted by time (and the constructor 
\code{tracks} enforces this).
}
\examples{
## A single 1D track
x <- tracks( matrix(c(0, 8,  
10, 9, 
20, 7, 
30, 7,
40, 6, 
50, 5), ncol=2, byrow=TRUE ) )

## Three 3D tracks
x2 <- tracks( rbind(
 c(0,5,0), c(1,5,3), c(2,1,3), c(3,5,6) ),
 rbind( c(0,1,1),c(1,1,4),c(2,5,4),c(3,5,1),c(4,-3,1) ),
 rbind( c(0,7,0),c(1,7,2),c(2,7,4),c(3,7,7) ) )

}

