% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate-tracks.R
\name{beaucheminTrack}
\alias{beaucheminTrack}
\title{Simulate a 3D Cell Track Using the Beauchemin Model}
\usage{
beaucheminTrack(sim.time = 10, delta.t = 1, p.persist = 0, p.bias = 0.9,
  bias.dir = c(0, 0, 0), taxis.mode = 1, t.free = 2, v.free = 18.8,
  t.pause = 0.5)
}
\arguments{
\item{sim.time}{specifies the duration of the track to be generated}

\item{delta.t}{change in time between each timepoint.}

\item{p.persist}{indicates how probable a change in direction is. With p.persist = 1,
the direction never changes between steps and with p.persist = 0, a new direction is 
sampled at every step.}

\item{p.bias}{strength of movement in the direction of \code{bias.dir}.}

\item{bias.dir}{a 3D vector indicating the direction along which there is a 
preference for movement.}

\item{taxis.mode}{specified mode of movement. 1 := orthotaxis, 2 := topotaxis, 
3 := klinotaxis.}

\item{t.free}{time interval for how long the cell is allowed to move between turns.}

\item{v.free}{speed of the cell during the free motion.}

\item{t.pause}{time that it takes the cell to adjust movement to new direction.}
}
\value{
A track, i.e., a matrix with \code{t/delta.t} rows and 4 columns.
}
\description{
The Beauchemin model is a simple, particle-based description of T cell motion in lymph
node in the absence of antigen, which is similar to a random walk (Beauchemin et al, 
2007).
}
\details{
In the Beauchemin model, cells move into a fixed direction for a fixed time \code{t.free}
at a fixed speed \code{v.free}. They then switch to a different direction, which is 
sampled at uniform from a sphere. The change of direction takes a fixed time \code{t.pause},
during which the cell does not move. Thus, the Beauchemin model is identical to the 
freely jointed chain model of polymer physics, except for the explicit "pause phase" 
between subsequent steps.

The default parameters implemented in this function 
were found to most accurately describe 'default' T
cell motion in lymph nodes using least-squares fitting to the mean displacement plot
(Beauchemin et al, 2007). 

This function implements an extended version of the Beauchemin model, which can also 
simulate directionally biased motion. For details, see Textor et al (2013).
}
\examples{
## Create track with model parameters and return matrix of positions
out <- beaucheminTrack(sim.time=20,p.persist = 0.3,taxis.mode = 1)
## Plot X-Y projection
plot( wrapTrack(out) )

## Create 20 tracks and plot them all
out <- simulateTracks( 20, beaucheminTrack(sim.time=10,
  bias.dir=c(-1,1,0),p.bias=10,taxis.mode = 2,
  p.persist = 0.1,delta.t = 1) )
plot( out )
}
\references{
Catherine Beauchemin, Narendra M. Dixit and Alan S. Perelson (2007), Characterizing 
T cell movement within lymph nodes in the absence of antigen. \emph{Journal of Immunology}
\bold{178}(9), 5505-5512. doi:10.4049/jimmunol.178.9.5505

Johannes Textor, Mathieu Sinn and Rob J. de Boer (2013), Analytical results on the 
Beauchemin model of lymphocyte migration. \emph{BMC Bioinformatics} \bold{14}(Suppl 6), S10.
doi:10.1186/1471-2105-14-S6-S10
}

