% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.morthump.r
\name{plot.morthump}
\alias{plot.morthump}
\title{Plot diagnostic for a morthump object}
\usage{
\method{plot}{morthump}(x, which, ...)
}
\arguments{
\item{x}{morthump object resulting from a call to the morthump function}

\item{which}{type of plot to be produced (see details)}

\item{...}{other parameters to be passed through to plotting functions}
}
\description{
Two plots (selectable by \code{which}) are currently available. They represent the age-specific death rates, and the density of the hump.
}
\details{
\code{Plot 1} displays the observed age-specific death rates, along with the fitted force of mortality and a estimation of what it look like if there was no young adult mortality hump.

\code{Plot 2} displays the age-specific contributions to the hump. These contributions are rescaled in order for the hump to sum up to 1.
Consequently, the surface can be interpreted as a probability density function (pdf), from which summary indicators can be computed such as the mean, mode and median age at death due to the hump.
Other summary indicators can be obtained by calling \link{summary.morthump}.
}
\examples{

data("CHE2010m")
fit <- morthump(data = CHE2010m, model = "sse")
plot(fit, which = 2)

}
\seealso{
\link{morthump}, \link{summary.morthump}
}

