% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axPreston.R
\name{axPreston}
\alias{axPreston}
\title{axPreston approximation of a(x) using a few rules of thumb outlined by Preston et al (2001)}
\usage{
axPreston(Mx, n, axsmooth = TRUE, sex = "female")
}
\arguments{
\item{Mx}{a numeric vector of the age-specific central death rates, calculated as D(x)/N(x) (deaths/exposure).}

\item{n}{a numeric vector of age interval widths.}

\item{axsmooth}{logical. default = \code{TRUE}. Should the a(x) values be calculated from a smoothed M(x) series? In this case, the M(x) series is smoothed within the function for a(x) estimation, but the smoothed M(x) function that was used is not returned. In general, it is better to smooth the M(x) function prior to putting it in this function, because the loess smoother used here has no weights or offset. If this is not possible, loess M(x) smoothing still produces more consistent and less erratic a(x) estimates.}

\item{sex}{\code{"male"} or \code{"female"}. default = \code{"female"}. The Coale Demeny rules of thumb are different for males and females.}
}
\value{
a numeric vector of a(x) values.
}
\description{
a(x) estimated assuming death rate constant in each interval. Most a values are estimated using \code{ax = n + (1/Mx) - n/(1-exp(-n*Mx))}, except for a0, which uses a few rules of thumb derived from Coale and Demeny (1983) and displayed in table 3.3 in Preston (2001). In the case of single ages, I found that ages a1-a10 were all estimated very close to .5, whereas the older ages a50+ were all estimated very close to what other methods produce. In order to adjust a(x) values
}
\details{
In the case of single ages, I found that ages a1-a10 were all estimated very close to .5, whereas the older ages a50+ were all estimated very close to what other methods produce. In order to adjust a(x) values to reflect dropping mortality at young ages, I wrote the following rule of thumb, which scales based on the level of mortality at age 0 and age 8. Basically the drop in mortality from age 0 to 8 ought to produce successively larger a(x) values, approaching .5. The increments in a(x) at each age from 1 until 8 are thus applied according to some fixed proportions, contained in the variable 'jumps'. This is the last code chunk in the function, which is displayed below under 'examples'. For more info, look at the code.
}
\author{
Tim Riffe
}
\references{
Coale Anseley and Paul Demeny, with B Vaughan (1983). Regional Model Life Tables and Stable Populations. New York Academic Press.

Preston, S. et al (2001) Demography: measuring and modeling population processes. Blackwell Publishing. Malden
}
\seealso{
See Also as \code{\link{axEstimate}}, a wrapper function for this and three other a(x) estimation procedures (\code{\link{axMidpoint}}, \code{\link{axKeyfitz}} and \code{\link{axSchoen}}).
}

