% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls2B.r
\name{pls2B}
\alias{pls2B}
\title{Two-Block partial least square regression.}
\usage{
pls2B(
  x,
  y,
  tol = 1e-12,
  same.config = FALSE,
  rounds = 0,
  useCor = FALSE,
  cv = FALSE,
  cvlv = NULL,
  mc.cores = parallel::detectCores(),
  ...
)
}
\arguments{
\item{x}{array containing superimposed landmark data second block.Matrices
are also allowed but the option 'same.config' will not work.}

\item{y}{array containing superimposed landmark data of the first block.
Matrices are also allowed but the option 'same.config' will not work.}

\item{tol}{threshold for discarding singular values.}

\item{same.config}{logical: if \code{TRUE} each permutation includes new
superimposition of permuted landmarks. This is necessary if both blocks
originate from landmarks that are superimposed together.}

\item{rounds}{rounds of permutation testing.}

\item{useCor}{if TRUE, the correlation matrix instead of the covariance matrix is used.}

\item{cv}{logical: if TRUE, a leave-one-out cross-validation is performed}

\item{cvlv}{integer: number of latent variables to test}

\item{mc.cores}{integer: determines how many cores to use for the}

\item{...}{arguments passed to \code{\link{ProcGPA}}
computation. The default is autodetect. But in case, it doesn't work as
expected cores can be set manually. Parallel processing is disabled on
Windows due to occasional errors.}
}
\value{
\item{svd }{singular value decomposition (see \code{\link{svd}}) of the
'common' covariance block}
\item{Xscores }{PLS-scores of x}
\item{Yscores }{PLS-scores of y}
\item{CoVar }{Dataframe containing singular values, explained
covariation, correlation coeffictient between PLS-scores and p-values for singular values obtained from permutation testing}
\item{xlm}{linear model: \code{lm(Xscores ~ Yscores - 1)}}
\item{ylm}{linear model: \code{lm(Yscores ~ Xscores - 1)}}
\item{predicted.x}{array containing matrices of cross-validated predictions for \code{x}(landmarks arrays will be vectorized using \code{\link{vecx}})}
\item{predicted.y}{array containing matrices of cross-validated predictions for \code{y} (landmarks arrays will be vectorized using \code{\link{vecx}})}
\item{rv}{RV-coefficient}
\item{p.value.RV}{p-value for RV-coefficient determined by permutation testing}
}
\description{
Performs a Two-Block PLS on two sets of data and assesses the significance
of each score by permutation testing
}
\details{
The Two-Block PLS tries to find those linear combinations in each block
maximising the covariance between blocks. The significance of each linear
combination is assessed by comparing the singular value to those obtained
from permuted blocks. If both blocks contain landmarks superimposed
TOGETHER, the option \code{same.config=TRUE} requests superimposition of the
permuted configurations (i.e. where the the landmarks of block \code{x} are
replaced by corresponding landmarks of other specimen.
}
\examples{

if (require(shapes)) {
### very arbitrary test:
### check if first 4 landmarks covaries with the second 4
proc <- procSym(gorf.dat)
## we do only 50 rounds to minimize computation time
\dontrun{#same.config takes too long for CRAN check
pls1 <- pls2B(proc$rotated[1:4,,],proc$rotated[5:8,,],
              same.config=TRUE,rounds=50,mc.cores=2)
}
pls1 <- pls2B(proc$rotated[1:4,,],proc$rotated[5:8,,],
              same.config=FALSE,rounds=50,mc.cores=1)
pls1
layout(matrix(1:4,2,2,byrow=TRUE))
for(i in 1:4)
 plot(pls1$Xscores[,i]~pls1$Yscores[,i])


## predict first 4 landmarks from second 4 for first config
layout(1)
predPLS <- predictPLSfromData(pls1,y=proc$rotated[5:8,,1])
## show differences between prediction and original
deformGrid2d(predPLS,proc$rotated[1:4,,1],pch=19)
##plot the complete first config
points(proc$rotated[,,1])

##show effects of first latent variable
plsEffects <- plsCoVar(pls1,i=1)
deformGrid2d(plsEffects$x[,,1],plsEffects$x[,,2])##show on x
deformGrid2d(plsEffects$y[,,1],plsEffects$y[,,2],add=TRUE,pch=19)##show on y

##show effects of 2nd latent variable
plsEffects2 <- plsCoVar(pls1,i=2)
deformGrid2d(plsEffects2$x[,,1],plsEffects2$x[,,2])##show on x
deformGrid2d(plsEffects2$y[,,1],plsEffects2$y[,,2],add=TRUE,pch=19)##show on y
}
}
\references{
Rohlf FJ, Corti M. 2000. Use of two-block partial least-squares
to study covariation in shape. Systematic Biology 49:740-753.
}
\seealso{
\code{\link{plsCoVar}, \link{getPLSfromScores}, \link{predictPLSfromScores}, \link{getPLSscores}, \link{predictPLSfromData},\link{svd} , \link{plsCoVarCommonShape}, \link{getPLSCommonShape}}
}
\author{
Stefan Schlager
}
