% Generated by roxygen2 (4.0.2): do not edit by hand
\name{fixLMtps}
\alias{fixLMtps}
\title{estimate missing landmarks}
\usage{
fixLMtps(data, comp = 3, weight = TRUE)
}
\arguments{
\item{data}{array containing landmark data}

\item{comp}{integer: select how many of the closest observations are to be
taken to calculate an initial estimate.}

\item{weight}{logical: requests the calculation of an estimate based on the
procrustes distance. Otherwise the sample's consensus is used as reference.}
}
\value{
\item{out }{array containing all data, including fixed configurations - same order as input}
\item{mshape }{meanshape - calculated from complete datasets}
\item{checklist }{list containing information about missing landmarks}
\item{check }{vector containing position of observations in data where at least one missing coordinate was found}
}
\description{
Missing landmarks are estimated by deforming a sample average or a weighted
estimate of the configurations most similar onto the deficient
configuration. The deformation is performed by a Thin-plate-spline
interpolation calculated by the available landmarks.
}
\details{
This function tries to estimate missing landmark data by mapping weighted
averages from complete datasets onto the missing specimen. The weights are
the inverted Procrustes (see \code{\link{proc.weight}}) distances between
the 'comp' closest specimen (using the available landmark configuration).
}
\note{
Be aware that these estimates might be grossly wrong when the missing
landmark is quite far off the rest of the landmarks (due to the radial basis
function used in the Thin-plate spline interpolation.
}
\examples{
require(rgl)
require(shapes)
data <- gorf.dat
### set first landmark of first specimen to NA
data[1,,1] <- NA
repair <- fixLMtps(data,comp=5)
### view difference between estimated and actual landmark
plot(repair$out[,,1],asp=1,pch=21,cex=0.7,col=2)#estimated landmark
points(gorf.dat[,,1],col=3,pch=20)#actual landmark

## 3D-example:
data(boneData)
data <- boneLM
### set first and 5th landmark of first specimen to NA
data[c(1,5),,1] <- NA
repair <- fixLMtps(data,comp=10)
##  view difference between estimated and actual landmark
\dontrun{
deformGrid3d(repair$out[,,1], boneLM[,,1],ngrid=0)
}
}
\author{
Stefan Schlager
}
\references{
Bookstein FL. 1989. Principal Warps: Thin-plate splines and the
decomposition of deformations IEEE Transactions on pattern analysis and
machine intelligence 11.
}
\seealso{
\code{\link{proc.weight}}, \code{\link{tps3d}}
}

