% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-out-rfourier.R
\name{rfourier_shape}
\alias{rfourier_shape}
\title{Calculates and draw 'rfourier' shapes.}
\usage{
rfourier_shape(an, bn, nb.h, nb.pts = 80, alpha = 2, plot = TRUE)
}
\arguments{
\item{an}{\code{numeric}. The \eqn{a_n} Fourier coefficients on which to
calculate a shape.}

\item{bn}{\code{numeric}. The \eqn{b_n} Fourier coefficients on which to
calculate a shape.}

\item{nb.h}{\code{integer}. The number of harmonics to use.}

\item{nb.pts}{\code{integer}. The number of points to calculate.}

\item{alpha}{\code{numeric}. The power coefficient associated with the
(usually decreasing) amplitude of the Fourier coefficients (see
\bold{Details}).}

\item{plot}{\code{logical}. Whether to plot or not the shape.}
}
\value{
A matrix of (x; y) coordinates.
}
\description{
\code{rfourier_shape} calculates a 'Fourier radii variation shape' given
Fourier coefficients (see \code{Details}) or can generate some 'rfourier'
shapes.
}
\details{
\code{rfourier_shape} can be used by specifying \code{nb.h} and
\code{alpha}. The coefficients are then sampled in an uniform distribution
\eqn{(-\pi ; \pi)} and this amplitude is then divided by
\eqn{harmonicrank^alpha}. If \code{alpha} is lower than 1, consecutive
coefficients will thus increase. See \link{rfourier} for the mathematical
background.
}
\examples{
data(bot)
rf <- rfourier(bot[1], 24)
rfourier_shape(rf$an, rf$bn) # equivalent to rfourier_i(rf)
rfourier_shape() # not very interesting

rfourier_shape(nb.h=12) # better
rfourier_shape(nb.h=6, alpha=0.4, nb.pts=500)

# Butterflies of the vignette' cover
panel(Out(a2l(replicate(100,
rfourier_shape(nb.h=6, alpha=0.4, nb.pts=200, plot=FALSE)))))
}
\references{
Claude, J. (2008) \emph{Morphometrics with R}, Use R! series,
Springer 316 pp.
}
\seealso{
Other rfourier: \code{\link{rfourier_i}},
  \code{\link{rfourier}}
}
