% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-domesticplotters.R
\name{ldk_confell}
\alias{ldk_confell}
\title{Draws confidence ellipses for landmark positions}
\usage{
ldk_confell(ldk, conf = 0.5, col = "grey40", ell.lty = 1, ax = TRUE,
  ax.lty = 2)
}
\arguments{
\item{ldk}{an array (or a list) of landmarks}

\item{conf}{the confidence level (normal quantile, 0.5 by default)}

\item{col}{the color for the ellipse}

\item{ell.lty}{an lty for the ellipse}

\item{ax}{logical whether to draw ellipses axes}

\item{ax.lty}{an lty for ellipses axes}
}
\description{
Draws confidence ellipses for landmark positions
}
\examples{
data(wings)
coo_plot(mshapes(wings))
ldk_confell(wings$coo)
}
\seealso{
Other plotting functions: \code{\link{Ntable}},
  \code{\link{conf_ell}}, \code{\link{coo_arrows}},
  \code{\link{coo_draw}}, \code{\link{coo_listpanel}},
  \code{\link{coo_lolli}}, \code{\link{coo_plot}},
  \code{\link{coo_ruban}}, \code{\link{ldk_chull}},
  \code{\link{ldk_contour}}, \code{\link{ldk_labels}},
  \code{\link{ldk_links}}, \code{\link{plot_devsegments}}

Other ldk plotters: \code{\link{ldk_chull}},
  \code{\link{ldk_contour}}, \code{\link{ldk_labels}},
  \code{\link{ldk_links}}
}
