% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inference.R
\name{forward_sampling}
\alias{forward_sampling}
\title{Forward Sampling}
\usage{
forward_sampling(bn, dag, target, evi, size, ...)
}
\arguments{
\item{bn}{A list of lists obtained from the function \link{MoTBFs_Learning}.}

\item{dag}{An object of class \code{"bn"}, representing the directed acyclic graph.}

\item{target}{A character string equal to the name of the variable of interest.}

\item{evi}{A \code{data.frame} containing the observed variables.}

\item{size}{A positive integer giving the number of instances to be generated.}

\item{...}{Optional arguments passed on to the \code{\link{univMoTBF}} function. \code{evalRange}, \code{nparam} and \code{maxParam} can be specified. \code{POTENTIAL_TYPE} is taken from the 'bn' object.}
}
\value{
A list containing the conditional distribution of the target variable and a data.frame with the generated sample.
}
\description{
\code{forward_sampling()} returns the conditional distribution of a target variable given a set of oberved variables.
The forward sampling algorithm approximates the conditional distribution from a random sample.
}
\examples{

## Dataset
  data("ecoli", package = "MoTBFs")
  data <- ecoli[,-c(1,9)]

## Get directed acyclic graph
  dag <- LearningHC(data)
  
## Learn bayesian network
  bn <- MoTBFs_Learning(dag, data = data, numIntervals = 4, POTENTIAL_TYPE = "MTE")
  
## Specify the evidence set and target variable
  obs <- data.frame(lip = "0.48", alm1 = 0.55, gvh = 1, stringsAsFactors=FALSE)
  node <- "alm2"
  
## Get the conditional distribution of 'node' and the generated sample
  forward_sampling(bn, dag, target = node, evi = obs, size = 10, maxParam = 15)
  
}
\references{
Henrion, M. (1988). Propagating uncertainty in Bayesian networks by probabilistic logic sampling. In Machine Intelligence and Pattern Recognition (Vol. 5, pp. 149-163). North-Holland.
}
