% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint.R
\name{coef.jointmotbf}
\alias{coef.jointmotbf}
\title{Coefficients of a \code{"jointmotbf"} object}
\usage{
\method{coef}{jointmotbf}(object, ...)
}
\arguments{
\item{object}{An MoTBF function.}

\item{\dots}{Other arguments, unnecessary for this function.}
}
\value{
A \code{"numeric"} vector with the parameters of the function.
}
\description{
Extracts the parameters of a joint MoTBF density.
}
\examples{
## Generate a dataset
data <- data.frame(X1 = rnorm(100), X2 = rnorm(100))

## Joint function
dim <-c(2,4)
param <- parametersJointMoTBF(data, dimensions = dim)
P <- jointMoTBF(param)
P$Time

## Coefficients
coef(P)

#############################################################################
## MORE EXAMPLES ############################################################
#############################################################################
\donttest{
## Generate a dataset
data <- data.frame(X1 = rnorm(100), X2 = rnorm(100), X3 = rnorm(100))
 
## Joint function
dim <-c(2,4,3)
param <- parametersJointMoTBF(data, dimensions = dim)
P <- jointMoTBF(param)
P$Time

## Coefficients
coef(P)
}
}
\seealso{
\link{parametersJointMoTBF} and \link{jointMoTBF}
}
