% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/priorKnowledge.R
\name{UpperBoundLogLikelihood}
\alias{UpperBoundLogLikelihood}
\title{Upper Bound Loglikelihood}
\usage{
UpperBoundLogLikelihood(f, data, min, max)
}
\arguments{
\item{f}{A function to evaluate of class \code{"character"}, \code{"motbf"} or others.}

\item{data}{A \code{"numeric"} array which contains the values to evaluate.}

\item{min}{A \code{"numeric"} value giving the lower limit of the function.}

\item{max}{A \code{"numeric"} value giving the highter limit of the function.}
}
\value{
A \code{"numeric"} value which is the log-likelihood of the evaluated ramdom function.
}
\description{
Computes an upper bound of the expected loglikelihood of a dataset given a randomly
generated MoTBF density.
}
\examples{
data <- rnorm(20)
f <- getNonNormalisedRandomMoTBF(degree = 8, POTENTIAL_TYPE = "MOP")
UpperBoundLogLikelihood(f, data, min = -2.5, max = 3.2)

data <- rexp(20)
f <- getNonNormalisedRandomMoTBF(degree = 8, POTENTIAL_TYPE = "MTE")
UpperBoundLogLikelihood(f, data, min = 0, max = 5)
}
\seealso{
\link{getNonNormalisedRandomMoTBF}
}

