% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_coreFunctions.R, R/4_auxiliaryFunctions.R
\name{estimateMobilityNetwork}
\alias{estimateMobilityNetwork}
\alias{estimateDistributionNetwork}
\alias{print.result.monan}
\title{estimateMobilityNetwork}
\usage{
estimateMobilityNetwork(
  state,
  cache,
  effects,
  algorithm,
  initialParameters = NULL,
  prevAns = NULL,
  parallel = FALSE,
  cpus = 1,
  verbose = FALSE,
  returnDeps = FALSE,
  fish = FALSE
)

estimateDistributionNetwork(
  state,
  cache,
  effects,
  algorithm,
  initialParameters = NULL,
  prevAns = NULL,
  parallel = FALSE,
  cpus = 1,
  verbose = FALSE,
  returnDeps = FALSE,
  fish = FALSE
)

\method{print}{result.monan}(x, covMat = FALSE, ...)
}
\arguments{
\item{state}{An object of class "processState.monan" which contains all relevant information about
the outcome in the form of an edgelist, the nodesets, and covariates.}

\item{cache}{A cache object created from the same state object that is
used in the estimation.}

\item{effects}{An object of class "effectsList.monan" that specifies the model.}

\item{algorithm}{An object of class "algorithm.monan" which specifies the algorithm used in the estimation.}

\item{initialParameters}{Starting values for the parameters. Using starting
values, e.g., from a multinomial logit model (see \code{\link[=getMultinomialStatistics]{getMultinomialStatistics()}})
increases the chances of model convergence in the first run of the estimation
considerably.}

\item{prevAns}{If a previous estimation did not yield satisfactory convergence,
the outcome object of that estimation should be specified here to provide new
starting values for the estimation.}

\item{parallel}{Logical: computation on multiple cores?}

\item{cpus}{Number of cores for computation in case parallel = TRUE.}

\item{verbose}{Logical: display information about estimation progress in the console?}

\item{returnDeps}{Logical: should the simulated values of Phase 3 be stored and returned?
This is necessary to run GoF tests.
Note that this might result in very large objects.}

\item{fish}{Logical: display a fish?}

\item{x}{An object of class "result.monan".}

\item{covMat}{Logical: indicating whether the covariance matrix should be printed.}

\item{...}{For internal use only.}
}
\value{
The function \code{estimateMobilityNetwork} returns an object of class "result.monan" that contains the estimates, standard errors,
and convergence statistics. Furthermore, the covariance matrix used to calculate
the standard errors is included, which also shows collinearity between effects.
In case returnDeps = TRUE, the simulations of Phase 3 are included, too.

The function \code{print.result.monan} prints the results from a monan
estimation with three columns indicating the estimate, the standard error,
and the convergence statistic.
}
\description{
The core function of the package in which the model for the analysis of
mobility tables is estimated.
}
\examples{
\donttest{
# estimate mobility network model

myResDN <- estimateMobilityNetwork(myState, myCache, myEffects, myAlg,
                                   initialParameters = NULL,
                                   # in case a pseudo-likelihood estimation was run, replace with
                                   # initialParameters = initEst,
                                   parallel = TRUE, cpus = 4,
                                   verbose = TRUE,
                                   returnDeps = TRUE,
                                   fish = FALSE
)

# check convergence
max(abs(myResDN$convergenceStatistics))

# view results
myResDN
}
myResDN
}
\seealso{
\code{\link[=createProcessState]{createProcessState()}}, \code{\link[=createWeightedCache]{createWeightedCache()}},
\code{\link[=createEffectsObject]{createEffectsObject()}}, \code{\link[=createAlgorithm]{createAlgorithm()}}
}
