% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_mutations.R
\name{id_snps}
\alias{id_snps}
\title{ID SNV-based Amino Acid Changes}
\usage{
id_snps(variant.calls, ref, code.num = "1")
}
\arguments{
\item{variant.calls}{Data frame with cols POS, REF, ALT, AF (alt freq), DP (total read depth).}

\item{ref}{reference genome in "MixVir" format (from create_ref() function)}

\item{code.num}{Number defining the genetic code to use for translation}
}
\value{
Data frame that includes amino acid calls based on SNP/SNV variants observed in sample. Contains cols "POS", "REF_BASE", "GENE", "REF_CODON", "REF_AA", "GENE_AA_POS", "REF_IDENT", "REF", "ALT", "ALT_freq", "ALT_COUNT", "samp_codon", "samp_AA", "samp_identity", "DP"
}
\description{
Identify amino acid changes associated with single nucleotide variation. Changes associated with indels are identified in separate function. Used by call_mutations() function.
}
\keyword{snps}
