% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixscale.R
\name{mixscale}
\alias{mixscale}
\title{Continuous scale mixture approach for parametric mixture model}
\usage{
mixscale(x, ini, maxiter = 50)
}
\arguments{
\item{x}{univariate data vector}

\item{ini}{ini:ini$mu: initial mu vector; ini$sigma: initial common variance;
ini$pi: initial proportion vector vector}

\item{maxiter}{the maximum iteration the algorithm run, default is 50}
}
\value{
out$mu: mu vector; out$pi: proportion vector; out$bb: support of Q; out$weight: weight of Q corresponding to ini.bb;
out$lik: log-likelihood (Since the algorithm converges to different values you may compare this)
}
\description{
Estimation procedure for a class of semiparametric
mixture models that is a mixture of unknown location-shifted symmetric distributions. The
proposed method assumes that the nonparametric symmetric distribution falls in a rich
class of continuous normal scale mixture distributions.
}
\examples{
n<- 10
mu <- c(-2.5,0); sd <- c(0.8,0.6); pi <- c(0.3,0.7)
set.seed(2023)
n1=rbinom(n,1,pi[1])
x=c(rnorm(sum(n1),mu[1],sd[1]),rnorm(n-sum(n1),mu[2],sd[2]))
ini=list(pi=pi,mu=mu,sigma=sd);
out=mixscale(x,ini, maxiter=1);
}
