% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ClusterKernel.R
\name{clusterKernel}
\alias{clusterKernel}
\title{Create an instance of the [\code{\linkS4class{ClusterKernel}}] class}
\usage{
clusterKernel(data, dim = 10, nbCluster = 2,
  modelNames = "kernelGaussian_pk_s", kernelName = "gaussian",
  kernelParameters = 1, strategy = clusterStrategy(), criterion = "ICL",
  nbCore = 1)
}
\arguments{
\item{data}{frame or matrix containing the data. Rows correspond to observations
and columns correspond to variables.}

\item{dim}{integer giving the dimension of the Gaussian density. Default is 10.}

\item{nbCluster}{[\code{\link{vector}}] listing the number of clusters to test.}

\item{modelNames}{[\code{\link{vector}}] of model names to run. By default only
"kernelGaussian_pk_s" is estimated. All the model names are given by the method
[\code{\link{clusterKernelNames}}].}

\item{kernelName}{string with a kernel name. Possible values:
"gaussian", "polynomial", "exponential". Default is "gaussian".}

\item{kernelParameters}{[\code{\link{vector}}] with the parameters of
the chosen kernel. Default is 1.}

\item{strategy}{a [\code{\linkS4class{ClusterStrategy}}] object containing
the strategy to run. [\code{\link{clusterStrategy}}]() method by default.}

\item{criterion}{character defining the criterion to select the best model.
The best model is the one with the lowest criterion value.
Possible values: "BIC", "AIC", "ICL". Default is "ICL".}

\item{nbCore}{integer defining the number of processor to use (default is 1, 0 for all).}
}
\value{
An instance of the [\code{\linkS4class{ClusterKernel}}] class.
}
\description{
This function computes the optimal kernel mixture model according
to the [\code{criterion}] among the number of clusters given in
[\code{nbCluster}], using the strategy specified in [\code{strategy}].
}
\note{
in the ClusterKernel instance returned by the function, data is the Gram matrix.
}
\examples{
## A quantitative example with the famous geyser data set
data(bullsEye)
## estimate model (using fast strategy, results may be misleading)
model <- clusterKernel( data=bullsEye[,1:2], nbCluster=2:3
                      , modelNames= "kernelGaussian_pk_s"
                      , strategy = clusterFastStrategy()
                      )

## use graphics functions
\dontrun{
plot(model)
}

## get summary
summary(model)
## print model
\dontrun{
print(model)
}
}
\author{
Serge Iovleff
}

