% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MISSINGPLOT.R
\name{Missing.RBD}
\alias{Missing.RBD}
\title{Missing Plot in Randomized Block Design(RBD)}
\usage{
Missing.RBD(m, r, c)
}
\arguments{
\item{m}{a matrix containing values in a RBD where row of the matrix denotes the treatments and the column of the matrix denotes  block. In this matrix, we will replace the missing value with 0.}

\item{r}{the index no. of row containing the missing value.}

\item{c}{the index no. of column containing the missing value.}
}
\value{
x.hat : the least sqaure estimate of the missing observation.

SSE.x.hat : Sum of Squares of Error of x.hat.

x.double.hat : the least square estimate of the missing observation under the null hypothesis , H0.

SSE.x.double.hat : Sum of Squares of Error of x.double.hat.

F.stat : Observed value of the Test Statistic.

F.crit.value : Critical value of the Test Statistic.
}
\description{
This function analyses RBD when there is one missing observation.
}
\details{
In RBD setup , if there is one missing observation we can use this function to estimate the missing observation along with Sum of Squares for testing the differential effect of the treatments. Here we estimate the missing observation twice by minimizing the SSE of the design.
}
\examples{
 p=matrix(c(12,15,16,18,16,21,0,27,29,30,35,36),nrow=4,ncol=3,byrow=TRUE )
 Missing.RBD(p,3,1)
}
\author{
Arnab Roy , Debarghya Baul.
}
