% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div_test.R
\name{multipatt_pq}
\alias{multipatt_pq}
\title{Test and plot multipatt result}
\usage{
multipatt_pq(
  physeq,
  fact,
  p_adjust_method = "BH",
  pval = 0.05,
  control = permute::how(nperm = 999),
  ...
)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{fact}{(required) Name of the factor in \code{physeq@sam_data} used to plot
different lines}

\item{p_adjust_method}{(chr, default "BH"): the method used to adjust p-value}

\item{pval}{(int, default 0.05): the value to determine the significance of
LCBD}

\item{control}{see \code{?indicspecies::multipatt()}}

\item{...}{Others arguments passed on to \code{\link[indicspecies:multipatt]{indicspecies::multipatt()}} function}
}
\value{
A ggplot2 object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A wrapper for the \code{\link[indicspecies:multipatt]{indicspecies::multipatt()}} function in the case of
\code{physeq} object.
}
\details{
This function is mainly a wrapper of the work of others.
Please make a reference to \code{indicspecies::multipatt()} if you
use this function.
}
\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "windows") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
if (requireNamespace("indicspecies")) {
  data(data_fungi)
  data_fungi_ab <- subset_taxa_pq(data_fungi, taxa_sums(data_fungi) > 10000)
  multipatt_pq(subset_samples(data_fungi_ab, !is.na(Time)), fact = "Time")
}
\donttest{
if (requireNamespace("indicspecies")) {
  multipatt_pq(subset_samples(data_fungi_ab, !is.na(Time)),
    fact = "Time",
    max.order = 1, control = permute::how(nperm = 99)
  )
}
}
\dontshow{\}) # examplesIf}
}
\author{
Adrien Taudière
}
