% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bioscrop}
\alias{bioscrop}
\title{Climate variables}
\format{
A raster brick with 3 variables:
\describe{
  \item{bio1}{Annual Mean Temperature}
  \item{bio7}{Temperature Annual Range}
  \item{bio12}{Annual Precipitation}
}
}
\source{
\url{https://worldclim.org}
}
\usage{
bioscrop
}
\description{
A raster brick containing 3 climate variables (resolution: 5 minutes) to be used as predictors for modelling species distributions
#' Coord. ref. : +init=EPSG:4326 +proj=longlat +datum=WGS84 +no_defs +ellps=WGS84 +towgs84=0,0,0.
}
\examples{
bioscrop <- raster::brick(paste0(system.file(package='MinBAR'), "/extdata/bioscrop.tif"))
names(bioscrop) <- c("bio1", "bio7", "bio12")
bioscrop

}
\references{
Fick, S.E. and R.J. Hijmans, 2017. Worldclim 2: New 1-km spatial resolution climate surfaces for global land areas. International Journal of Climatology.
}
\keyword{datasets}
