% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{weighted_var}
\alias{weighted_var}
\title{Weighted Variance}
\usage{
weighted_var(x, w = NULL, method = c("unbiased", "ML"), na.rm = FALSE, ...)
}
\arguments{
\item{x}{Numeric vector.}

\item{w}{Optional vector of non-negative case weights.}

\item{method}{Specifies how the result is scaled. If "unbiased", the denomiator
is reduced by 1, see \code{\link[stats:cov.wt]{stats::cov.wt()}} for details.}

\item{na.rm}{Should missing values in \code{x} be removed? Default is \code{FALSE}.}

\item{...}{Further arguments passed to \code{\link[stats:cov.wt]{stats::cov.wt()}}.}
}
\value{
A length-one numeric vector.
}
\description{
Calculates weighted variance, see \code{\link[stats:cov.wt]{stats::cov.wt()}} or
\url{https://en.wikipedia.org/wiki/Sample_mean_and_covariance#Weighted_samples}
for details.
}
\examples{
weighted_var(1:10)
weighted_var(1:10, w = NULL)
weighted_var(1:10, w = rep(1, 10))
weighted_var(1:10, w = 1:10)
weighted_var(1:10, w = 1:10, method = "ML")
}
\seealso{
\code{\link[stats:cov.wt]{stats::cov.wt()}}
}
