% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_squared.R
\name{r_squared}
\alias{r_squared}
\title{Pseudo R-Squared}
\usage{
r_squared(actual, predicted, w = NULL, deviance_function = mse, ...)
}
\arguments{
\item{actual}{Observed values.}

\item{predicted}{Predicted values.}

\item{w}{Optional case weights.}

\item{deviance_function}{A positive (deviance) function taking four arguments: "actual", "predicted", "w" and "...".}

\item{...}{Further arguments passed to \code{weighted_mean} and \code{deviance_function}.}
}
\value{
A numeric vector of length one.
}
\description{
Returns (weighted) proportion of deviance explained, see reference below. For the mean-squared error as deviance, this equals the usual (weighted) R-squared. The higher, the better.
}
\details{
For simplicity, the deviance gain is calculated regarding the null model derived from the actual values.
}
\examples{
r_squared(1:10, c(1, 1:9))
r_squared(1:10, c(1, 1:9), w = rep(1, 10))
r_squared(1:10, c(1, 1:9), w = 1:10)
r_squared(1:10, c(1, 1:9), deviance_function = deviance_normal)
r_squared(0:2, c(0.1, 1, 2), deviance_function = deviance_poisson)
r_squared(0:2, c(0.1, 1, 2), w = rep(1, 3), deviance_function = deviance_poisson)
r_squared(0:2, c(0.1, 1, 2), deviance_function = deviance_tweedie, tweedie_p = 1)
r_squared(0:2, c(0.1, 1, 2), w = rep(1, 3),
  deviance_function = deviance_tweedie, tweedie_p = 1)

# respect to own deviance formula
myTweedie <- function(actual, predicted, w = NULL, ...) {
  deviance_tweedie(actual, predicted, w, tweedie_p = 1.5, ...)
}
r_squared(1:10, c(1, 1:9), deviance_function = myTweedie)
}
\references{
Cohen, Jacob. et al. (2002). Applied Multiple Regression/Correlation Analysis for the Behavioral Sciences (3rd ed.). Routledge. ISBN 978-0805822236.
}
\seealso{
\code{\link{deviance_normal}, \link{mse}}.
}
