% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MBoxplot.R
\name{MBoxplot}
\alias{MBoxplot}
\title{MBoxplot.}
\usage{
MBoxplot(
  pk = pk,
  raw = NULL,
  sam = NULL,
  met = NULL,
  g = NULL,
  flt = NULL,
  an = NULL,
  plot_sample_n = FALSE,
  txt = NULL,
  cex.txt = 0.5,
  plot_rel_axis = NULL,
  ...
)
}
\arguments{
\item{pk}{Colname of raw to plot if \code{pk} is character OR the colnum number if \code{pk} is numeric.}

\item{raw}{Plotting data as samples (rows) x metabolites (cols).}

\item{sam}{Sample table.}

\item{met}{Containing at minimum columns for annotation (see parameter \code{an}) and \code{nrow(met)} should be \code{ncol(raw)}.}

\item{g}{Grouping vector if \code{Group} not contained in \code{sam}.}

\item{flt}{Filter to exclude certain samples (T/F) vector.}

\item{an}{Switch to include annotation (from met) in the boxplot providing a character vector of colnames from \code{met}.}

\item{plot_sample_n}{Amend each box with the number of finite values which were a basis for plotting this group.}

\item{txt}{Character vector with information per sample to be plotted on top of the box as text.}

\item{cex.txt}{Specify size of annotation text.}

\item{plot_rel_axis}{Specify one level of \code{g} (or \code{sam$Group}) which to express the data relative against.}

\item{...}{Further options parsed to \code{boxplot}.}
}
\value{
Nothing. Will produce a plot (or file if specified).
}
\description{
\code{MBoxplot} will generate an annotated boxplot. A unifying
  function for MS-data Boxplots based on \'raw\' and \'sam\'.
}
\details{
Usually metabolomics experiments are conducted on multiple replicates
  of a sample group. Boxplots allow to quickly access potential differences
  between measurement values of several groups. \code{MBoxplot} can be nicely
  used to generate QC plots for all metabolites prior and after normalization,
  in absolute or relative scale and sorted according to significance.
}
\examples{
x <- data.frame("y" = runif(36), "GT" = gl(3, 12), "TP" = factor(rep(rep(1:3, each = 4), 3)))
x <- cbind(x, AdjustSymbols(cols = x$GT, pchs = x$TP))
MBoxplot(
  pk = "y", raw = x, sam = x, met = data.frame("Peak" = "y", "Test" = I("info")),
  g = interaction(x$GT, x$TP), an = "Test", plot_n_samples = TRUE, txt = rownames(x)
)
}
