% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_MBMA_dat.R
\name{create_MBMA_dat}
\alias{create_MBMA_dat}
\title{Prepare model-based meta-analysis dataset for Stan.}
\usage{
create_MBMA_dat(
  dat = dat,
  armVars = c(dose = "t", responders = "r", sampleSize = "n"),
  nArmsVar = "nd"
)
}
\arguments{
\item{dat}{Data in one-study-per-row format.}

\item{armVars}{Vector of per-arm variables
The name of each component will be the column name in the resulting dataset.}

\item{nArmsVar}{Variable holding the number of arms for each study.}
}
\value{
A data frame with the generated coloumns.
}
\description{
\code{create_MBMA_dat} converts datasets in the one-study-per-row
format to one-arm-per-row format,
}
\details{
The resulting data.frame can be used as data argument in \code{MBMA_stan}.
}
\examples{
data('dat.Eletriptan')
## Create the dataset suitable for MBMA_stan
EletriptanDat <- create_MBMA_dat(dat = dat.Eletriptan,
armVars = c("dose" = "d", "r" = "r", "n" = "n"), nArmsVar = 'nd')
## Check that the data are correct
print(EletriptanDat)
}
\seealso{
\code{gemtc::mtc.data.studyrow} and \code{nmaINLA::create_INLA_dat}
}
\author{
Burak Kuersad Guenhan, \email{burak.gunhan@med.uni-goettingen.de}
and Gert van Valkenhoef
}
