% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Metalonda.R
\name{metalondaAll}
\alias{metalondaAll}
\title{Metagenomic Longitudinal Differential Abundant Analysis for all features}
\usage{
metalondaAll(data, Time, Group, ID, n.perm = 10, log = FALSE,
  fit.method = "nbinomial", points, parall = FALSE,
  pvalue_threshold = 0.05, adjust.method = "BH")
}
\arguments{
\item{data}{Count matrix of all features}

\item{Time}{Time label of all samples}

\item{Group}{Group label of all samples}

\item{ID}{individual ID label for samples}

\item{n.perm}{number of permutations}

\item{log}{log transformation of the data}

\item{fit.method}{The fitting method (NB, LOWESS)}

\item{points}{The points at which the prediction should happen}

\item{parall}{logic to indicate whether to use multicore}

\item{pvalue_threshold}{p-value threshold cutoff}

\item{adjust.method}{Multiple testing correction methods}
}
\value{
Returns a list of the significant features a long with their significant time intervals
}
\description{
Find significant features and their time interval
}
\references{
Ahmed Metwally (ametwa2@uic.edu)
}
