% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestPlot.R
\name{forestPlot}
\alias{forestPlot}
\title{Compare effect sizes of a gene across all datasets in meta-analysis}
\usage{
forestPlot(metaObject, geneName, boxColor = "blue", whiskerColor = "lightblue", 
zeroLineColor = "black", summaryColor = "orange", textColor = "red")
}
\arguments{
\item{metaObject}{a filtered metaObject, i.e. it needs to include a \code{filterObject} generated by the function \code{filterGenes()}}

\item{geneName}{name of the gene for which the forest plot should be generated}

\item{boxColor}{desired color for the box, default = "blue"}

\item{whiskerColor}{desired color for the whiskers, default = "lightblue"}

\item{zeroLineColor}{desired color for the line indicating 0, default = "black"}

\item{summaryColor}{desired color for the diamond representing the summary effect size, default = "orange"}

\item{textColor}{desired color for the text of the dataset names, default = "red"}
}
\value{
Plot to compare effect sizes of a gene across datasets
}
\description{
A forest plot can be used to compare the expression values of a gene across different datasets. The size of the blue boxes is proportional to the number of samples in the study and light blue lines indicate the standard error of the effect sizes for each study (95\% confidence interval). The summary effect size for all studies is indicated as yellow diamond below and the width of the diamond indicates the summary standard error.
}
\examples{
# compare effect sizes of the Gene1 for all discovery datasets in tinyMetaObject 
forestPlot(tinyMetaObject, geneName="Gene1")
}
\seealso{
\code{\link{filterGenes}},  \code{\link{runMetaAnalysis}},  \code{\link{violinPlot}}
}
\author{
Winston A. Haynes, Jiaying Toh
}
\keyword{graphs}
\keyword{hplot}
