% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-db_parsers.R
\name{build.MCDB}
\alias{build.MCDB}
\title{Build MCDB}
\usage{
build.MCDB(outfolder, testMode = FALSE)
}
\arguments{
\item{outfolder}{Which folder to save temp files to?}

\item{testMode}{run in test mode? Only parses first ten compounds}
}
\value{
data table with parsed database
}
\description{
Parses the MCDB, returns data table with columns compoundname, description, charge, formula and structure (in SMILES)
}
\examples{
\dontrun{build.MCDB(outfolder = tempdir(), testMode = TRUE)}
\dontrun{build.MCDB(outfolder=tempdir(), testMode=TRUE)}
}
\seealso{
\code{\link[utils]{download.file}},\code{\link[utils]{unzip}}
 \code{\link[RCurl]{getURL}}
 \code{\link[XML]{readHTMLTable}},\code{\link[XML]{xmlValue}},\code{\link[XML]{xmlEventParse}}
 \code{\link[data.table]{rbindlist}}
 \code{\link[pbapply]{pboptions}}
 \code{\link[base]{connections}}
 \code{\link[stringr]{str_match}}
}
