% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/metasumm.R
\name{metasumm}
\alias{metasumm}
\title{Meta-analysis summary statistics}
\usage{
metasumm(dat, resd, egger = FALSE)
}
\arguments{
\item{dat}{Meta-analysis data. This should be a data frame with three columns, called "name", "est" and "se" giving the study name, study-specific parameter estimates and corresponding standard errors respectively.

Numeric or character study names are permitted.  If the data frame has more than three columns, the first three are used.  If the first three columns are called "name", "est" and "se" in some order, they are re-ordered appropriately, otherwise they are re-named.}

\item{resd}{Random effects standard deviation.  Set \code{resd=0} for a fixed effects meta-analysis.  If \code{resd} is omitted, a random effects meta-analysis is performed using the typical DerSimonian and Laird method to obtain the standard deviation (\code{\link{resd_dsl}}).}

\item{egger}{Set to \code{TRUE} to perform Egger correction.}
}
\value{
A list with the following components:

\item{est}{Original study-specific estimates (if \code{egger=FALSE}) or Egger-corrected version of these (if \code{egger=TRUE}).}

\item{pool}{Pooled estimate}

\item{poolse}{Pooled standard error}

\item{poolci}{Pooled 95\% confidence interval}

\item{pwtfe}{Weights for fixed effects model, normalised to sum to 1}

\item{pwtre}{Weights for desired random effects standard deviation, normalised to sum to 1}
}
\description{
Compute meta-analysis weights and corresponding pooled estimates given a set of estimates and standard errors.  Weights are simply defined by the inverse variance, where the variance is the sum of the study-specific and random effects variance.
}

