% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2genabel.R
\name{Mega2ENVGenABEL}
\alias{Mega2ENVGenABEL}
\title{generate gwaa.data-class object}
\usage{
Mega2ENVGenABEL(markers = NULL, force = TRUE, makemap = FALSE,
  sort = TRUE, envir = ENV)
}
\arguments{
\item{markers}{data frame of markers to be processed}

\item{force}{pass value to gwaa conversion function}

\item{makemap}{pass value to gwaa conversion function}

\item{sort}{pass value to gwaa conversion function}

\item{envir}{'environment' containing SQLite database and other globals}
}
\value{
gwaa.data-class object created from Mega2R database
}
\description{
create a gwaa.data-class object from the data frames in a Mega2 environment.  This
 function is a front end that eventually calls a C++ Rcpp function that reads
 the genotype data in Mega2 compressed format and converts it to the GenABEL
 compressed format.  The results of \code{Mega2ENVGenABEL} are/should be the same
 as \code{Mega2GenABEL}, but the calculation is much faster, typically a factor of 10 to 20.
}
\examples{
db = system.file("exdata", "seqsimm.db", package="Mega2R")
ENV = read.Mega2DB(db)
gwaa = Mega2ENVGenABEL(markers=ENV$markers[1:10,])

str(gwaa)
head(summary(gwaa))

}
