% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2skat.R
\name{DOSKAT}
\alias{DOSKAT}
\title{SKAT call back function}
\usage{
DOSKAT(markers_arg, range_arg, envir, ...)
}
\arguments{
\item{markers_arg}{a data.frame with the following 5 observations:
\describe{
\item{locus_link}{is the ordinal ranking of this marker among all loci}
\item{locus_link_fill}{is the position of corresponding genotype data in the
\emph{unified_genotype_table}}
\item{MarkerName}{is the text name of the marker}
\item{chromosome}{is the integer chromosome number}
\item{position}{is the integer base pair position of marker}
}}

\item{range_arg}{one row of a ranges_arg.  The latter is a data frame of at least three
integer columns.  The columns indicate a range:
a chromosome number, a start base pair value, and an end base pair value.}

\item{envir}{'environment' containing SQLite database and other globals}

\item{...}{extra arguments for SKAT}
}
\value{
None
}
\description{
Convert the genotypesraw() allele patterns of 0x10001, 0x10002 (or 0x20001), 0x20002, 0
 to the numbers 0, 1, 2, 9 for each marker. (Reverse, the order iff allele "1" has the
 minor allele frequency.)  Ignore markers that have no variants (unless allMarkers is TRUE).
 Finally, invoke \code{SKAT} with the converted genotype matrix, Null model saved in envir$obj,
 and any additionally supplied arguments.
 Save information about the range and the p.value calculated by \code{SKAT}
 in \emph{envir$SKAT_results}.
}
\note{
This function accumulates output in the data frame, \emph{envir$SKAT_results}.  It will
 print out the lines as they are generated if \emph{envir$verbose} is TRUE.  It does not write
 the data frame to a file.  You must save the data frame.
 You also must initialize the data frame when necessary.
}
\examples{
db = system.file("exdata", "seqsimm.db", package="Mega2R")
ENV = init_SKAT(db, verbose = FALSE, allMarkers = FALSE)
Mega2SKAT(ENV$phe[, 3] - 1 ~ 1, "D", gs=1:1)

# try this below instead if there is time

# DOSKAT is called internally to Mega2SKAT. init_SKAT and Mega2SKAT need to be
# called to set up the environment for DOSKAT to run.  You should ignore DOSKAT
# and use Mega2SKAT instead
#
ENV$verbose = TRUE
applyFnToRanges(DOSKAT, ENV$refRanges[50:60, ], ENV$refIndices)

}
\seealso{
\code{\link{init_SKAT}}, \code{\link{Mega2SKAT}}
}
