% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseMeasurementUse.R
\name{summariseMeasurementUse}
\alias{summariseMeasurementUse}
\title{Diagnostics of a codelist of measurement codes in the database}
\usage{
summariseMeasurementUse(
  cdm,
  codes,
  byConcept = TRUE,
  byYear = FALSE,
  bySex = FALSE,
  ageGroup = NULL,
  dateRange = as.Date(c(NA, NA)),
  checks = c("measurement_timings", "measurement_value_as_numeric",
    "measurement_value_as_concept")
)
}
\arguments{
\item{cdm}{A reference to the cdm object.}

\item{codes}{A codelist of measurement/observation codes for which to perform
diagnostics.}

\item{byConcept}{TRUE or FALSE. If TRUE code use will be summarised by concept.}

\item{byYear}{TRUE or FALSE. If TRUE code use will be summarised by year.}

\item{bySex}{TRUE or FALSE. If TRUE code use will be summarised by sex.}

\item{ageGroup}{If not NULL, a list of ageGroup vectors of length two.}

\item{dateRange}{Two dates. The first indicating the earliest measurement
date and the second indicating the latest possible measurement date.}

\item{checks}{Diagnostics to run. Options are: "measurement_timing",
"measurement_value_as_numeric", and "measurement_value_as_concept".}
}
\value{
A summarised result
}
\description{
Diagnostics of a codelist of measurement codes in the database
}
\examples{
\donttest{
library(MeasurementDiagnostics)
cdm <- mockMeasurementDiagnostics()
result <- summariseMeasurementUse(
  cdm = cdm, codes = list("test_codelist" = c(3001467L, 45875977L))
)
CDMConnector::cdmDisconnect(cdm = cdm)
}
}
