% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MazamaSpatialUtils.R
\name{simplify}
\alias{simplify}
\title{Simplify simple features data frame}
\usage{
simplify(SFDF, keep = 0.05, ...)
}
\arguments{
\item{SFDF}{Object of class simple features data frame.}

\item{keep}{Proportion of points to retain (0-1; default 0.05)}

\item{...}{Arguments passed to \code{rmapshaper::ms_simplify()}}
}
\value{
A simplified spatial polygons dataframe.
}
\description{
Simplify a spatial polygons dataframe. This is a convenience
wrapper for \code{\link[rmapshaper]{ms_simplify}}
}
\examples{
\dontrun{
library(MazamaSpatialUtils)
FR <-
  SimpleCountries \%>\%
  dplyr::filter(countryCode == "FR")
par(mfrow = c(3, 3), mar = c(1, 1, 3, 1))
for (i in 9:1) {
  keep <- 0.1 * i
  geom <-
    FR \%>\%
    simplify(keep) \%>\%
    sf::st_geometry()
  plot(geom, main=paste0("keep = ", keep))
}
layout(1)
par(mar = c(5,4,4,2)+.1)
}
}
