% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertOSMTimezones.R
\name{convertOSMTimezones}
\alias{convertOSMTimezones}
\title{Convert OSM Timezone Shapefile}
\usage{
convertOSMTimezones(dsnPath = NULL, nameOnly = FALSE)
}
\arguments{
\item{dsnPath}{optional directory where the timezones.shapefile.zip file is found (in case web access isn't working)}

\item{nameOnly}{logical specifying whether to only return the name without creating the file}
}
\value{
Name of the dataset being created.
}
\description{
A world timezone shapefile is downloaded from \url{https://github.com/evansiroky/timezone-boundary-builder/releases}
and converted to a SpatialPolygonsDataFrame with additional columns of data. The resulting file will be created
in the spatial data directory which is set with \code{setSpatialDataDir()}.
}
\note{
There are 86 timezones which have polygons but the associated rows in the dataframe have no data. 
These timezones also have no \code{countryCode} assigned. We hope to rectify this in a future release. 
These are the missing timezones:
\preformatted{
> OSMTimezones@data$timezone[is.na(OSMTimezones$countryCode)]
 [1] "Africa/Addis_Ababa"    "Africa/Asmara"         "Africa/Bamako"         "Africa/Bangui"         "Africa/Banjul"        
 [6] "Africa/Blantyre"       "Africa/Brazzaville"    "Africa/Bujumbura"      "Africa/Conakry"        "Africa/Dakar"         
[11] "Africa/Dar_es_Salaam"  "Africa/Djibouti"       "Africa/Douala"         "Africa/Freetown"       "Africa/Gaborone"      
[16] "Africa/Harare"         "Africa/Juba"           "Africa/Kampala"        "Africa/Kigali"         "Africa/Kinshasa"      
[21] "Africa/Libreville"     "Africa/Lome"           "Africa/Luanda"         "Africa/Lubumbashi"     "Africa/Lusaka"        
[26] "Africa/Malabo"         "Africa/Maseru"         "Africa/Mbabane"        "Africa/Mogadishu"      "Africa/Niamey"        
[31] "Africa/Nouakchott"     "Africa/Ouagadougou"    "Africa/Porto-Novo"     "Africa/Sao_Tome"       "America/Anguilla"     
[36] "America/Antigua"       "America/Aruba"         "America/Cayman"        "America/Coral_Harbour" "America/Dominica"     
[41] "America/Grenada"       "America/Guadeloupe"    "America/Kralendijk"    "America/Lower_Princes" "America/Marigot"      
[46] "America/Montreal"      "America/Montserrat"    "America/St_Barthelemy" "America/St_Kitts"      "America/St_Lucia"     
[51] "America/St_Thomas"     "America/St_Vincent"    "America/Tortola"       "Arctic/Longyearbyen"   "Asia/Aden"            
[56] "Asia/Bahrain"          "Asia/Chongqing"        "Asia/Harbin"           "Asia/Kashgar"          "Asia/Kuwait"          
[61] "Asia/Muscat"           "Asia/Phnom_Penh"       "Asia/Rangoon"          "Asia/Vientiane"        "Atlantic/St_Helena"   
[66] "Europe/Bratislava"     "Europe/Busingen"       "Europe/Guernsey"       "Europe/Isle_of_Man"    "Europe/Jersey"        
[71] "Europe/Ljubljana"      "Europe/Mariehamn"      "Europe/Podgorica"      "Europe/San_Marino"     "Europe/Sarajevo"      
[76] "Europe/Skopje"         "Europe/Vaduz"          "Europe/Vatican"        "Europe/Zagreb"         "Indian/Antananarivo"  
[81] "Indian/Comoro"         "Indian/Mayotte"        "Pacific/Johnston"      "Pacific/Midway"        "Pacific/Saipan"       
[86] "Pacific/Yap"     
}
}
\references{
\url{https://github.com/evansiroky/timezone-boundary-builder/releases}
}
\seealso{
setSpatialDataDir

convertWikipediaTimezoneTable
}
\keyword{datagen}
