% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{operators}
\alias{operators}
\alias{*,RsparseMatrix,sparseMatrix-method}
\alias{*,ngRMatrix,sparseMatrix-method}
\alias{*,lgRMatrix,sparseMatrix-method}
\alias{*,sparseMatrix,RsparseMatrix-method}
\alias{*,sparseMatrix,ngRMatrix-method}
\alias{*,sparseMatrix,lgRMatrix-method}
\alias{*,CsparseMatrix,TsparseMatrix-method}
\alias{*,TsparseMatrix,CsparseMatrix-method}
\alias{&,RsparseMatrix,sparseMatrix-method}
\alias{&,ngRMatrix,sparseMatrix-method}
\alias{&,lgRMatrix,sparseMatrix-method}
\alias{&,sparseMatrix,RsparseMatrix-method}
\alias{&,sparseMatrix,ngRMatrix-method}
\alias{&,sparseMatrix,lgRMatrix-method}
\alias{&,CsparseMatrix,TsparseMatrix-method}
\alias{&,TsparseMatrix,CsparseMatrix-method}
\alias{*,RsparseMatrix,matrix-method}
\alias{*,ngRMatrix,matrix-method}
\alias{*,lgRMatrix,matrix-method}
\alias{*,RsparseMatrix,float32-method}
\alias{*,ngRMatrix,float32-method}
\alias{*,lgRMatrix,float32-method}
\alias{*,matrix,RsparseMatrix-method}
\alias{*,matrix,ngRMatrix-method}
\alias{*,matrix,lgRMatrix-method}
\alias{*,float32,RsparseMatrix-method}
\alias{*,float32,ngRMatrix-method}
\alias{*,float32,lgRMatrix-method}
\alias{&,RsparseMatrix,matrix-method}
\alias{&,ngRMatrix,matrix-method}
\alias{&,lgRMatrix,matrix-method}
\alias{&,matrix,RsparseMatrix-method}
\alias{&,matrix,ngRMatrix-method}
\alias{&,matrix,lgRMatrix-method}
\alias{*,TsparseMatrix,matrix-method}
\alias{*,TsparseMatrix,float32-method}
\alias{*,ngTMatrix,matrix-method}
\alias{*,lgTMatrix,matrix-method}
\alias{*,ngTMatrix,float32-method}
\alias{*,lgTMatrix,float32-method}
\alias{*,matrix,TsparseMatrix-method}
\alias{*,float32,TsparseMatrix-method}
\alias{*,matrix,ngTMatrix-method}
\alias{*,matrix,lgTMatrix-method}
\alias{*,float32,ngTMatrix-method}
\alias{*,float32,lgTMatrix-method}
\alias{&,TsparseMatrix,matrix-method}
\alias{&,ngTMatrix,matrix-method}
\alias{&,lgTMatrix,matrix-method}
\alias{&,matrix,TsparseMatrix-method}
\alias{&,matrix,ngTMatrix-method}
\alias{&,matrix,lgTMatrix-method}
\alias{*,CsparseMatrix,matrix-method}
\alias{*,CsparseMatrix,float32-method}
\alias{*,matrix,CsparseMatrix-method}
\alias{*,float32,CsparseMatrix-method}
\alias{&,CsparseMatrix,matrix-method}
\alias{&,CsparseMatrix,float32-method}
\alias{&,matrix,CsparseMatrix-method}
\alias{&,float32,CsparseMatrix-method}
\alias{+,RsparseMatrix,sparseMatrix-method}
\alias{+,ngRMatrix,sparseMatrix-method}
\alias{+,lgRMatrix,sparseMatrix-method}
\alias{+,sparseMatrix,RsparseMatrix-method}
\alias{+,sparseMatrix,ngRMatrix-method}
\alias{+,sparseMatrix,lgRMatrix-method}
\alias{+,CsparseMatrix,TsparseMatrix-method}
\alias{+,TsparseMatrix,CsparseMatrix-method}
\alias{-,RsparseMatrix,sparseMatrix-method}
\alias{-,ngRMatrix,sparseMatrix-method}
\alias{-,lgRMatrix,sparseMatrix-method}
\alias{-,sparseMatrix,RsparseMatrix-method}
\alias{-,sparseMatrix,ngRMatrix-method}
\alias{-,sparseMatrix,lgRMatrix-method}
\alias{-,CsparseMatrix,TsparseMatrix-method}
\alias{-,TsparseMatrix,CsparseMatrix-method}
\alias{|,RsparseMatrix,sparseMatrix-method}
\alias{|,ngRMatrix,sparseMatrix-method}
\alias{|,lgRMatrix,sparseMatrix-method}
\alias{|,sparseMatrix,RsparseMatrix-method}
\alias{|,sparseMatrix,ngRMatrix-method}
\alias{|,sparseMatrix,lgRMatrix-method}
\alias{|,CsparseMatrix,TsparseMatrix-method}
\alias{|,TsparseMatrix,CsparseMatrix-method}
\alias{*,RsparseMatrix,integer-method}
\alias{*,RsparseMatrix,numeric-method}
\alias{*,RsparseMatrix,logical-method}
\alias{*,integer,RsparseMatrix-method}
\alias{*,numeric,RsparseMatrix-method}
\alias{*,logical,RsparseMatrix-method}
\alias{&,RsparseMatrix,integer-method}
\alias{&,RsparseMatrix,numeric-method}
\alias{&,RsparseMatrix,logical-method}
\alias{&,integer,RsparseMatrix-method}
\alias{&,numeric,RsparseMatrix-method}
\alias{&,logical,RsparseMatrix-method}
\alias{/,RsparseMatrix,integer-method}
\alias{/,RsparseMatrix,numeric-method}
\alias{/,RsparseMatrix,logical-method}
\alias{/,RsparseMatrix,matrix-method}
\alias{/,integer,RsparseMatrix-method}
\alias{/,numeric,RsparseMatrix-method}
\alias{/,logical,RsparseMatrix-method}
\alias{/,matrix,RsparseMatrix-method}
\alias{\%\%,RsparseMatrix,integer-method}
\alias{\%\%,RsparseMatrix,numeric-method}
\alias{\%\%,RsparseMatrix,logical-method}
\alias{\%\%,RsparseMatrix,matrix-method}
\alias{\%\%,integer,RsparseMatrix-method}
\alias{\%\%,numeric,RsparseMatrix-method}
\alias{\%\%,logical,RsparseMatrix-method}
\alias{\%\%,matrix,RsparseMatrix-method}
\alias{\%/\%,RsparseMatrix,integer-method}
\alias{\%/\%,RsparseMatrix,numeric-method}
\alias{\%/\%,RsparseMatrix,logical-method}
\alias{\%/\%,RsparseMatrix,matrix-method}
\alias{\%/\%,integer,RsparseMatrix-method}
\alias{\%/\%,numeric,RsparseMatrix-method}
\alias{\%/\%,logical,RsparseMatrix-method}
\alias{\%/\%,matrix,RsparseMatrix-method}
\alias{^,RsparseMatrix,integer-method}
\alias{^,RsparseMatrix,numeric-method}
\alias{^,RsparseMatrix,logical-method}
\alias{^,RsparseMatrix,matrix-method}
\alias{^,integer,RsparseMatrix-method}
\alias{^,numeric,RsparseMatrix-method}
\alias{^,logical,RsparseMatrix-method}
\alias{^,matrix,RsparseMatrix-method}
\alias{*,TsparseMatrix,integer-method}
\alias{*,TsparseMatrix,numeric-method}
\alias{*,TsparseMatrix,logical-method}
\alias{*,integer,TsparseMatrix-method}
\alias{*,numeric,TsparseMatrix-method}
\alias{*,logical,TsparseMatrix-method}
\alias{&,TsparseMatrix,integer-method}
\alias{&,TsparseMatrix,numeric-method}
\alias{&,TsparseMatrix,logical-method}
\alias{&,integer,TsparseMatrix-method}
\alias{&,numeric,TsparseMatrix-method}
\alias{&,logical,TsparseMatrix-method}
\alias{/,TsparseMatrix,integer-method}
\alias{/,TsparseMatrix,numeric-method}
\alias{/,TsparseMatrix,logical-method}
\alias{/,TsparseMatrix,matrix-method}
\alias{/,integer,TsparseMatrix-method}
\alias{/,numeric,TsparseMatrix-method}
\alias{/,logical,TsparseMatrix-method}
\alias{/,matrix,TsparseMatrix-method}
\alias{\%\%,TsparseMatrix,integer-method}
\alias{\%\%,TsparseMatrix,numeric-method}
\alias{\%\%,TsparseMatrix,logical-method}
\alias{\%\%,TsparseMatrix,matrix-method}
\alias{\%\%,integer,TsparseMatrix-method}
\alias{\%\%,numeric,TsparseMatrix-method}
\alias{\%\%,logical,TsparseMatrix-method}
\alias{\%\%,matrix,TsparseMatrix-method}
\alias{\%/\%,TsparseMatrix,integer-method}
\alias{\%/\%,TsparseMatrix,numeric-method}
\alias{\%/\%,TsparseMatrix,logical-method}
\alias{\%/\%,TsparseMatrix,matrix-method}
\alias{\%/\%,integer,TsparseMatrix-method}
\alias{\%/\%,numeric,TsparseMatrix-method}
\alias{\%/\%,logical,TsparseMatrix-method}
\alias{\%/\%,matrix,TsparseMatrix-method}
\alias{^,TsparseMatrix,integer-method}
\alias{^,TsparseMatrix,numeric-method}
\alias{^,TsparseMatrix,logical-method}
\alias{^,TsparseMatrix,matrix-method}
\alias{^,integer,TsparseMatrix-method}
\alias{^,numeric,TsparseMatrix-method}
\alias{^,logical,TsparseMatrix-method}
\alias{^,matrix,TsparseMatrix-method}
\alias{*,RsparseMatrix,sparseVector-method}
\alias{*,sparseVector,RsparseMatrix-method}
\alias{*,matrix,sparseVector-method}
\alias{*,sparseVector,matrix-method}
\alias{*,float32,sparseVector-method}
\alias{*,sparseVector,float32-method}
\title{Mathematical operators on sparse matrices and sparse vectors}
\usage{
\S4method{*}{RsparseMatrix,sparseMatrix}(e1, e2)

\S4method{*}{ngRMatrix,sparseMatrix}(e1, e2)

\S4method{*}{lgRMatrix,sparseMatrix}(e1, e2)

\S4method{*}{sparseMatrix,RsparseMatrix}(e1, e2)

\S4method{*}{sparseMatrix,ngRMatrix}(e1, e2)

\S4method{*}{sparseMatrix,lgRMatrix}(e1, e2)

\S4method{*}{CsparseMatrix,TsparseMatrix}(e1, e2)

\S4method{*}{TsparseMatrix,CsparseMatrix}(e1, e2)

\S4method{&}{RsparseMatrix,sparseMatrix}(e1, e2)

\S4method{&}{ngRMatrix,sparseMatrix}(e1, e2)

\S4method{&}{lgRMatrix,sparseMatrix}(e1, e2)

\S4method{&}{sparseMatrix,RsparseMatrix}(e1, e2)

\S4method{&}{sparseMatrix,ngRMatrix}(e1, e2)

\S4method{&}{sparseMatrix,lgRMatrix}(e1, e2)

\S4method{&}{CsparseMatrix,TsparseMatrix}(e1, e2)

\S4method{&}{TsparseMatrix,CsparseMatrix}(e1, e2)

\S4method{*}{RsparseMatrix,matrix}(e1, e2)

\S4method{*}{ngRMatrix,matrix}(e1, e2)

\S4method{*}{lgRMatrix,matrix}(e1, e2)

\S4method{*}{RsparseMatrix,float32}(e1, e2)

\S4method{*}{ngRMatrix,float32}(e1, e2)

\S4method{*}{lgRMatrix,float32}(e1, e2)

\S4method{*}{matrix,RsparseMatrix}(e1, e2)

\S4method{*}{matrix,ngRMatrix}(e1, e2)

\S4method{*}{matrix,lgRMatrix}(e1, e2)

\S4method{*}{float32,RsparseMatrix}(e1, e2)

\S4method{*}{float32,ngRMatrix}(e1, e2)

\S4method{*}{float32,lgRMatrix}(e1, e2)

\S4method{&}{RsparseMatrix,matrix}(e1, e2)

\S4method{&}{ngRMatrix,matrix}(e1, e2)

\S4method{&}{lgRMatrix,matrix}(e1, e2)

\S4method{&}{matrix,RsparseMatrix}(e1, e2)

\S4method{&}{matrix,ngRMatrix}(e1, e2)

\S4method{&}{matrix,lgRMatrix}(e1, e2)

\S4method{*}{TsparseMatrix,matrix}(e1, e2)

\S4method{*}{TsparseMatrix,float32}(e1, e2)

\S4method{*}{ngTMatrix,matrix}(e1, e2)

\S4method{*}{lgTMatrix,matrix}(e1, e2)

\S4method{*}{ngTMatrix,float32}(e1, e2)

\S4method{*}{lgTMatrix,float32}(e1, e2)

\S4method{*}{matrix,TsparseMatrix}(e1, e2)

\S4method{*}{float32,TsparseMatrix}(e1, e2)

\S4method{*}{matrix,ngTMatrix}(e1, e2)

\S4method{*}{matrix,lgTMatrix}(e1, e2)

\S4method{*}{float32,ngTMatrix}(e1, e2)

\S4method{*}{float32,lgTMatrix}(e1, e2)

\S4method{&}{TsparseMatrix,matrix}(e1, e2)

\S4method{&}{ngTMatrix,matrix}(e1, e2)

\S4method{&}{lgTMatrix,matrix}(e1, e2)

\S4method{&}{matrix,TsparseMatrix}(e1, e2)

\S4method{&}{matrix,ngTMatrix}(e1, e2)

\S4method{&}{matrix,lgTMatrix}(e1, e2)

\S4method{*}{CsparseMatrix,matrix}(e1, e2)

\S4method{*}{CsparseMatrix,float32}(e1, e2)

\S4method{*}{matrix,CsparseMatrix}(e1, e2)

\S4method{*}{float32,CsparseMatrix}(e1, e2)

\S4method{&}{CsparseMatrix,matrix}(e1, e2)

\S4method{&}{CsparseMatrix,float32}(e1, e2)

\S4method{&}{matrix,CsparseMatrix}(e1, e2)

\S4method{&}{float32,CsparseMatrix}(e1, e2)

\S4method{+}{RsparseMatrix,sparseMatrix}(e1, e2)

\S4method{+}{ngRMatrix,sparseMatrix}(e1, e2)

\S4method{+}{lgRMatrix,sparseMatrix}(e1, e2)

\S4method{+}{sparseMatrix,RsparseMatrix}(e1, e2)

\S4method{+}{sparseMatrix,ngRMatrix}(e1, e2)

\S4method{+}{sparseMatrix,lgRMatrix}(e1, e2)

\S4method{+}{CsparseMatrix,TsparseMatrix}(e1, e2)

\S4method{+}{TsparseMatrix,CsparseMatrix}(e1, e2)

\S4method{-}{RsparseMatrix,sparseMatrix}(e1, e2)

\S4method{-}{ngRMatrix,sparseMatrix}(e1, e2)

\S4method{-}{lgRMatrix,sparseMatrix}(e1, e2)

\S4method{-}{sparseMatrix,RsparseMatrix}(e1, e2)

\S4method{-}{sparseMatrix,ngRMatrix}(e1, e2)

\S4method{-}{sparseMatrix,lgRMatrix}(e1, e2)

\S4method{-}{CsparseMatrix,TsparseMatrix}(e1, e2)

\S4method{-}{TsparseMatrix,CsparseMatrix}(e1, e2)

\S4method{|}{RsparseMatrix,sparseMatrix}(e1, e2)

\S4method{|}{ngRMatrix,sparseMatrix}(e1, e2)

\S4method{|}{lgRMatrix,sparseMatrix}(e1, e2)

\S4method{|}{sparseMatrix,RsparseMatrix}(e1, e2)

\S4method{|}{sparseMatrix,ngRMatrix}(e1, e2)

\S4method{|}{sparseMatrix,lgRMatrix}(e1, e2)

\S4method{|}{CsparseMatrix,TsparseMatrix}(e1, e2)

\S4method{|}{TsparseMatrix,CsparseMatrix}(e1, e2)

\S4method{*}{RsparseMatrix,integer}(e1, e2)

\S4method{*}{RsparseMatrix,numeric}(e1, e2)

\S4method{*}{RsparseMatrix,logical}(e1, e2)

\S4method{*}{integer,RsparseMatrix}(e1, e2)

\S4method{*}{numeric,RsparseMatrix}(e1, e2)

\S4method{*}{logical,RsparseMatrix}(e1, e2)

\S4method{&}{RsparseMatrix,integer}(e1, e2)

\S4method{&}{RsparseMatrix,numeric}(e1, e2)

\S4method{&}{RsparseMatrix,logical}(e1, e2)

\S4method{&}{integer,RsparseMatrix}(e1, e2)

\S4method{&}{numeric,RsparseMatrix}(e1, e2)

\S4method{&}{logical,RsparseMatrix}(e1, e2)

\S4method{/}{RsparseMatrix,integer}(e1, e2)

\S4method{/}{RsparseMatrix,numeric}(e1, e2)

\S4method{/}{RsparseMatrix,logical}(e1, e2)

\S4method{/}{RsparseMatrix,matrix}(e1, e2)

\S4method{/}{integer,RsparseMatrix}(e1, e2)

\S4method{/}{numeric,RsparseMatrix}(e1, e2)

\S4method{/}{logical,RsparseMatrix}(e1, e2)

\S4method{/}{matrix,RsparseMatrix}(e1, e2)

\S4method{\%\%}{RsparseMatrix,integer}(e1, e2)

\S4method{\%\%}{RsparseMatrix,numeric}(e1, e2)

\S4method{\%\%}{RsparseMatrix,logical}(e1, e2)

\S4method{\%\%}{RsparseMatrix,matrix}(e1, e2)

\S4method{\%\%}{integer,RsparseMatrix}(e1, e2)

\S4method{\%\%}{numeric,RsparseMatrix}(e1, e2)

\S4method{\%\%}{logical,RsparseMatrix}(e1, e2)

\S4method{\%\%}{matrix,RsparseMatrix}(e1, e2)

\S4method{\%/\%}{RsparseMatrix,integer}(e1, e2)

\S4method{\%/\%}{RsparseMatrix,numeric}(e1, e2)

\S4method{\%/\%}{RsparseMatrix,logical}(e1, e2)

\S4method{\%/\%}{RsparseMatrix,matrix}(e1, e2)

\S4method{\%/\%}{integer,RsparseMatrix}(e1, e2)

\S4method{\%/\%}{numeric,RsparseMatrix}(e1, e2)

\S4method{\%/\%}{logical,RsparseMatrix}(e1, e2)

\S4method{\%/\%}{matrix,RsparseMatrix}(e1, e2)

\S4method{^}{RsparseMatrix,integer}(e1, e2)

\S4method{^}{RsparseMatrix,numeric}(e1, e2)

\S4method{^}{RsparseMatrix,logical}(e1, e2)

\S4method{^}{RsparseMatrix,matrix}(e1, e2)

\S4method{^}{integer,RsparseMatrix}(e1, e2)

\S4method{^}{numeric,RsparseMatrix}(e1, e2)

\S4method{^}{logical,RsparseMatrix}(e1, e2)

\S4method{^}{matrix,RsparseMatrix}(e1, e2)

\S4method{*}{TsparseMatrix,integer}(e1, e2)

\S4method{*}{TsparseMatrix,numeric}(e1, e2)

\S4method{*}{TsparseMatrix,logical}(e1, e2)

\S4method{*}{integer,TsparseMatrix}(e1, e2)

\S4method{*}{numeric,TsparseMatrix}(e1, e2)

\S4method{*}{logical,TsparseMatrix}(e1, e2)

\S4method{&}{TsparseMatrix,integer}(e1, e2)

\S4method{&}{TsparseMatrix,numeric}(e1, e2)

\S4method{&}{TsparseMatrix,logical}(e1, e2)

\S4method{&}{integer,TsparseMatrix}(e1, e2)

\S4method{&}{numeric,TsparseMatrix}(e1, e2)

\S4method{&}{logical,TsparseMatrix}(e1, e2)

\S4method{/}{TsparseMatrix,integer}(e1, e2)

\S4method{/}{TsparseMatrix,numeric}(e1, e2)

\S4method{/}{TsparseMatrix,logical}(e1, e2)

\S4method{/}{TsparseMatrix,matrix}(e1, e2)

\S4method{/}{integer,TsparseMatrix}(e1, e2)

\S4method{/}{numeric,TsparseMatrix}(e1, e2)

\S4method{/}{logical,TsparseMatrix}(e1, e2)

\S4method{/}{matrix,TsparseMatrix}(e1, e2)

\S4method{\%\%}{TsparseMatrix,integer}(e1, e2)

\S4method{\%\%}{TsparseMatrix,numeric}(e1, e2)

\S4method{\%\%}{TsparseMatrix,logical}(e1, e2)

\S4method{\%\%}{TsparseMatrix,matrix}(e1, e2)

\S4method{\%\%}{integer,TsparseMatrix}(e1, e2)

\S4method{\%\%}{numeric,TsparseMatrix}(e1, e2)

\S4method{\%\%}{logical,TsparseMatrix}(e1, e2)

\S4method{\%\%}{matrix,TsparseMatrix}(e1, e2)

\S4method{\%/\%}{TsparseMatrix,integer}(e1, e2)

\S4method{\%/\%}{TsparseMatrix,numeric}(e1, e2)

\S4method{\%/\%}{TsparseMatrix,logical}(e1, e2)

\S4method{\%/\%}{TsparseMatrix,matrix}(e1, e2)

\S4method{\%/\%}{integer,TsparseMatrix}(e1, e2)

\S4method{\%/\%}{numeric,TsparseMatrix}(e1, e2)

\S4method{\%/\%}{logical,TsparseMatrix}(e1, e2)

\S4method{\%/\%}{matrix,TsparseMatrix}(e1, e2)

\S4method{^}{TsparseMatrix,integer}(e1, e2)

\S4method{^}{TsparseMatrix,numeric}(e1, e2)

\S4method{^}{TsparseMatrix,logical}(e1, e2)

\S4method{^}{TsparseMatrix,matrix}(e1, e2)

\S4method{^}{integer,TsparseMatrix}(e1, e2)

\S4method{^}{numeric,TsparseMatrix}(e1, e2)

\S4method{^}{logical,TsparseMatrix}(e1, e2)

\S4method{^}{matrix,TsparseMatrix}(e1, e2)

\S4method{*}{RsparseMatrix,sparseVector}(e1, e2)

\S4method{*}{sparseVector,RsparseMatrix}(e1, e2)

\S4method{*}{matrix,sparseVector}(e1, e2)

\S4method{*}{sparseVector,matrix}(e1, e2)

\S4method{*}{float32,sparseVector}(e1, e2)

\S4method{*}{sparseVector,float32}(e1, e2)
}
\arguments{
\item{e1}{A sparse or dense matrix or vector/}

\item{e2}{Another sparse or dense matrix or vector.}
}
\value{
A CSR or COO matrix depending on the input type and operation. Some operations
(blocked by default) will produce dense matrices as outputs.
}
\description{
Implements some mathematical operators between sparse-sparse and sparse-dense
matrices and vectors, such as `CSR + CSR`, `CSR + COO`, `CSR * vector`, `CSR * dense`, among
others, which typically work natively in the storage order of the inputs without data duplication.
}
\details{
By default, when doing elementwise multiplication (`*`) between a sparse and a dense
matrix or vice-versa, if the dense matrix has missing values (`NA` / `NaN`) at some coordinate in
which the sparse matrix has no present entry, the resulting output will not have an entry there either,
which differs from the behavior of `Matrix` and base R, but makes the operation much faster.
The same applies to division by zero and exponentiation to zero.

If such missing values (or infinites and ones) are to be preserved, this behavior can be
changed through the package options (i.e. `options("MatrixExtra.ignore_na" = FALSE)` - see
\link{MatrixExtra-options}).

The indices of the matrices might be sorted in-place for some operations
(see \link{sort_sparse_indices}).
}
\examples{
library(Matrix)
library(MatrixExtra)
set.seed(1)
X <- rsparsematrix(4, 3, .5, repr="R")
X + X
X * X
X * as.coo.matrix(X)
X * 2
X * 1:4
X ^ 2
X ^ (1:4)

### Beware
set_new_matrix_behavior()
suppressWarnings(X / 0)
restore_old_matrix_behavior()
suppressWarnings(X / 0)
}
