% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Matrix.utils.R
\name{merge.Matrix}
\alias{join.Matrix}
\alias{merge.Matrix}
\title{Merges two Matrices or matrix-like objects}
\usage{
\method{merge}{Matrix}(x, y, by.x = rownames(x), by.y = rownames(y),
  type = "left", ...)

join.Matrix(x, y, by.x = rownames(x), by.y = rownames(y), type = "left",
  ...)
}
\arguments{
\item{x}{\code{\link{Matrix}} or matrix-like object}

\item{y}{\code{Matrix} or matrix-like object}

\item{by.x}{vector indicating the names to match from \code{Matrix} x}

\item{by.y}{vector indicating the names to match from \code{Matrix} y}

\item{type}{type of join: currently on left and inner are supported}

\item{...}{arguments to be passed to or from methods.  Currently ignored}
}
\description{
Similar to \code{\link{merge}} or \code{\link[plyr]{join}}. Currently can only do left and 
inner joins that only find the first matching row; equivalent to 
plyr::join(match='first').  This is sufficient for N to 1 joins, such as joining a list of
addresses to a zip code lookup table.

Synonym for merge.Matrix.
}
\examples{
orders<-Matrix(as.matrix(data.frame(orderNum=1:1000,
   customer=sample(100,1000,TRUE))),sparse=TRUE)
cancelledOrders<-Matrix(as.matrix(data.frame(orderNum=sample(1000,100),
   cancelled=1)),sparse=TRUE)
skus<-Matrix(as.matrix(data.frame(orderNum=sample(1000,10000,TRUE),
   sku=sample(1000,10000,TRUE),
   amount=runif(10000))),sparse=TRUE)
a<-merge.Matrix(orders,cancelledOrders,orders[,'orderNum'],cancelledOrders[,'orderNum'])
b<-merge.Matrix(orders,cancelledOrders,orders[,'orderNum'],cancelledOrders[,'orderNum'],
   type='inner')
c<-merge.Matrix(orders,skus,orders[,'orderNum'],skus[,'orderNum'])

\dontrun{
## Not run:
orders<-data.frame(orderNum=sample(1e6, 1e7, TRUE),
   sku=sample(1e3, 1e7, TRUE),
   customer=sample(1e4,1e7,TRUE))
cancelledOrders<-data.frame(data.frame(orderNum=sample(1e6,1e5),cancelled=1))
system.time(b<-merge.Matrix(orders,cancelledOrders,orders[,'orderNum'],
   cancelledOrders[,'orderNum'],type='inner'))
#The following is the equivalent call in plyr, but returns an error due to a bug in plyr
system.time(c<-plyr::join(orders,cancelledOrders,type='inner',match='first')) 
}
}

