% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilMWRfiltersurface.R
\name{utilMWRfiltersurface}
\alias{utilMWRfiltersurface}
\title{Filter results data to surface measurements}
\usage{
utilMWRfiltersurface(resdat)
}
\arguments{
\item{resdat}{results data as returned by \code{\link{readMWRresults}}}
}
\value{
\code{resdat} filtered by \code{Activity Depth/Height Measure} less than or equal to 1 meter or 3.3 feet or \code{Activity Relative Depth Name} as \code{"Surface"}
}
\description{
Filter results data to surface measurements
}
\details{
This function is used internally for all analysis functions
}
\examples{
# results file path
respth <- system.file('extdata/ExampleResults.xlsx', package = 'MassWateR')

# results data
resdat <- readMWRresults(respth)

# filter surface data
utilMWRfiltersurface(resdat)
}
