% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkMWRwqx.R
\name{checkMWRwqx}
\alias{checkMWRwqx}
\title{Check water quality exchange (wqx) metadata input}
\usage{
checkMWRwqx(wqxdat, warn = TRUE)
}
\arguments{
\item{wqxdat}{input data frame}

\item{warn}{logical to return warnings to the console (default)}
}
\value{
\code{wqxdat} is returned as is if no errors are found, otherwise an informative error message is returned prompting the user to make the required correction to the raw data before proceeding. Checks with warnings can be fixed at the discretion of the user before proceeding.
}
\description{
Check water quality exchange (wqx) metadata input
}
\details{
This function is used internally within \code{\link{readMWRwqx}} to run several checks on the input data for conformance with downstream functions

The following checks are made:
\itemize{
\item{Column name spelling: }{Should be the following: Parameter, Sampling Method Context, Method Speciation, Result Sample Fraction, Analytical Method, Analytical Method Context}
\item{Columns present: }{All columns from the previous check should be present}
\item{Unique parameters: }{Values in \code{Parameter} should be unique (no duplicates)}
\item{Parameter: }{Should match parameter names in the \code{Simple Parameter} or \code{WQX Parameter} columns of the \code{\link{paramsMWR}} data (warning only)}
}
}
\examples{
library(dplyr)

wqxpth <- system.file('extdata/ExampleWQX.xlsx', package = 'MassWateR')

wqxdat <- readxl::read_excel(wqxpth, na = c('NA', 'na', ''), col_types = 'text')
    
checkMWRwqx(wqxdat)
}
