% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit}
\alias{fit}
\alias{fit.formula}
\alias{fit.matrix}
\alias{fit.ModelFrame}
\alias{fit.recipe}
\alias{fit.ModelSpecification}
\alias{fit.MLModel}
\alias{fit.MLModelFunction}
\title{Model Fitting}
\usage{
fit(...)

\method{fit}{formula}(formula, data, model, ...)

\method{fit}{matrix}(x, y, model, ...)

\method{fit}{ModelFrame}(input, model = NULL, ...)

\method{fit}{recipe}(input, model = NULL, ...)

\method{fit}{ModelSpecification}(object, ...)

\method{fit}{MLModel}(model, ...)

\method{fit}{MLModelFunction}(model, ...)
}
\arguments{
\item{...}{arguments passed from the generic function to its methods and from
the \code{MLModel} and \code{MLModelFunction} methods to others.  The
first argument of each \code{fit} method is positional and, as such, must
be given first in calls to them.}

\item{formula, data}{\link[=formula]{formula} defining the model predictor and
response variables and a \link[=data.frame]{data frame} containing them.}

\item{model}{\link[=models]{model} function, function name, or object; or
another object that can be \link[=as.MLModel]{coerced} to a model.  A model
can be given first followed by any of the variable specifications, and the
argument can be omitted altogether in the case of
\link[=ModeledInput]{modeled inputs}.}

\item{x, y}{\link{matrix} and object containing predictor and response
variables.}

\item{input}{\link[=inputs]{input} object defining and containing the model
predictor and response variables.}

\item{object}{model \link[=ModelSpecification]{specification}.}
}
\value{
\code{MLModelFit} class object.
}
\description{
Fit a model to estimate its parameters from a data set.
}
\details{
User-specified case weights may be specified for \code{ModelFrames} upon
creation with the \code{\link[=ModelFrame]{weights}} argument in its
constructor.

Variables in \code{recipe} specifications may be designated as case weights
with the \code{\link{role_case}} function.
}
\examples{
\donttest{
## Requires prior installation of suggested package gbm to run

## Survival response example
library(survival)

gbm_fit <- fit(Surv(time, status) ~ ., data = veteran, model = GBMModel)
varimp(gbm_fit)
}

}
\seealso{
\code{\link{as.MLModel}}, \code{\link{response}},
\code{\link{predict}}, \code{\link{varimp}}
}
