% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_sbf.R
\name{step_sbf}
\alias{step_sbf}
\alias{tidy.step_sbf}
\title{Variable Selection by Filtering}
\usage{
step_sbf(
  recipe,
  ...,
  filter,
  multivariate = FALSE,
  options = list(),
  replace = TRUE,
  prefix = "SBF",
  role = "predictor",
  skip = FALSE,
  id = recipes::rand_id("sbf")
)

\method{tidy}{step_sbf}(x, ...)
}
\arguments{
\item{recipe}{\link[recipes]{recipe} object to which the step will be added.}

\item{...}{one or more selector functions to choose which variables will be
used to compute the components.  See \code{\link[recipes]{selections}} for
more details.  These are not currently used by the \code{tidy} method.}

\item{filter}{function whose first argument \code{x} is a univariate vector
or a \code{multivariate} data frame of candidate variables from which to
select, second argument \code{y} is the response variable as
defined in preceding recipe steps, and third argument \code{step} is the
current step.  The function should return a logical value or vector of
length equal the number of variables in \code{x} indicating whether to
select the corresponding variable, or return a list or data frame with
element \code{`selected`} containing the logical(s) and possibly with other
elements of the same length to be included in output from the \code{tidy}
method.}

\item{multivariate}{logical indicating that candidate variables be passed to
the \code{x} argument of the \code{filter} function separately as
univariate vectors if \code{FALSE}, or altogether in one multivariate data
frame if \code{TRUE}.}

\item{options}{list of elements to be added to the step object for use in the
\code{filter} function.}

\item{replace}{logical indicating whether to replace the original variables.}

\item{prefix}{if the original variables are not replaced, the selected
variables are added to the dataset with the character string prefix added
to their names; otherwise, the original variable names are retained.}

\item{role}{analysis role that added step variables should be assigned.  By
default, they are designated as model predictors.}

\item{skip}{logical indicating whether to skip the step when the recipe is
baked.  While all operations are baked when \code{\link[recipes]{prep}} is
run, some operations may not be applicable to new data (e.g. processing
outcome variables).  Care should be taken when using \code{skip = TRUE} as
it may affect the computations for subsequent operations.}

\item{id}{unique character string to identify the step.}

\item{x}{\code{step_sbf} object.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of existing steps (if any).  For the \code{tidy} method, a tibble
with columns \code{terms} (selectors or variables selected), \code{selected}
(logical indicator of selected variables), and \code{name} of the selected
variable names.
}
\description{
Creates a \emph{specification} of a recipe step that will select variables
from a candidate set according to a user-specified filtering function.
}
\examples{
library(recipes)

glm_filter <- function(x, y, step) {
  model_fit <- glm(y ~ ., data = data.frame(y, x))
  p_value <- drop1(model_fit, test = "F")[-1, "Pr(>F)"]
  p_value < step$threshold
}

rec <- recipe(rating ~ ., data = attitude)
sbf_rec <- rec \%>\%
  step_sbf(all_numeric(), -all_outcomes(),
           filter = glm_filter, options = list(threshold = 0.05))

sbf_prep <- prep(sbf_rec, training = attitude)
sbf_data <- bake(sbf_prep, attitude)

pairs(sbf_data, lower.panel = NULL)

tidy(sbf_rec, number = 1)
tidy(sbf_prep, number = 1)

}
\seealso{
\code{\link[recipes]{recipe}}, \code{\link[recipes]{prep}},
\code{\link[recipes]{bake}}
}
