% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{inputs}
\alias{inputs}
\title{Model Inputs}
\description{
Model inputs are the predictor and response variables whose relationship is
determined by a model fit.  Input specifications supported by
\pkg{MachineShop} are summarized in the table below.
\tabular{ll}{
  \code{\link{formula}}         \tab Traditional model formula \cr
  \code{\link{matrix}}          \tab Design matrix of predictors \cr
  \code{\link{ModelFrame}}      \tab Model frame \cr
  \code{\link[recipes]{recipe}} \tab Preprocessing recipe roles and steps \cr
}
Response variable types in the input specifications are defined by the user
with the functions and recipe roles:
\tabular{ll}{
  \strong{Response Functions}
    \tab \code{\link{BinomialVariate}} \cr
    \tab \code{\link{DiscreteVariate}} \cr
    \tab \code{\link{factor}} \cr
    \tab \code{\link{matrix}} \cr
    \tab \code{\link{NegBinomialVariate}} \cr
    \tab \code{\link{numeric}} \cr
    \tab \code{\link{ordered}} \cr
    \tab \code{\link{PoissonVariate}} \cr
    \tab \code{\link[survival]{Surv}} \cr
  \strong{Recipe Roles}
    \tab \code{\link{role_binom}} \cr
    \tab \code{\link{role_surv}} \cr
}
Inputs may be combined, selected, or tuned with the following meta-input
functions.
\tabular{ll}{
  \code{\link{ModeledInput}}  \tab Input with a prespecified model \cr
  \code{\link{SelectedInput}} \tab Input selection from a candidate set \cr
  \code{\link{TunedInput}}    \tab Input tuning over a parameter grid \cr
}
}
\seealso{
\code{\link{fit}}, \code{\link{resample}}
}
