% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit}
\alias{fit}
\alias{fit.formula}
\alias{fit.matrix}
\alias{fit.ModelFrame}
\alias{fit.recipe}
\alias{fit.MLModel}
\alias{fit.MLModelFunction}
\title{Model Fitting}
\usage{
fit(x, ...)

\method{fit}{formula}(x, data, model, ...)

\method{fit}{matrix}(x, y, model, ...)

\method{fit}{ModelFrame}(x, model, ...)

\method{fit}{recipe}(x, model, ...)

\method{fit}{MLModel}(x, ...)

\method{fit}{MLModelFunction}(x, ...)
}
\arguments{
\item{x}{defines a relationship between model predictor and response
variables.  May be a \code{\link{formula}}, design \code{\link{matrix}} of
predictors, \code{\link{ModelFrame}}, untrained
\code{\link[recipes]{recipe}}, or \code{\link{TunedRecipe}} object.
Alternatively, a \link[=models]{model} function or call may be given first
followed by objects defining the predictor and response relationship.}

\item{...}{arguments passed to other methods.}

\item{data}{\link[=data.frame]{data frame} containing observed predictors and
outcomes.}

\item{model}{\link[=models]{model} function, function name, or call.}

\item{y}{response variable.}
}
\value{
\code{MLModelFit} class object.
}
\description{
Fit a model to estimate its parameters from a data set.
}
\details{
User-specified case weights may be specified for \code{ModelFrames} upon
creation with the \code{\link[=ModelFrame]{weights}} argument in its
constructor.

Variables in a \code{recipe} may be used as case weights by defining a
"case_weight" \code{\link[recipes:roles]{role}} for them.
}
\examples{
## Survival response example
library(survival)
library(MASS)

gbm_fit <- fit(Surv(time, status != 2) ~ sex + age + year + thickness + ulcer,
               data = Melanoma, model = GBMModel)
varimp(gbm_fit)

}
\seealso{
\code{\link{response}}, \code{\link{predict}}, \code{\link{varimp}}
}
