% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-factor.R, R/metrics-numeric.R
\name{metrics}
\alias{metrics}
\alias{accuracy}
\alias{auc}
\alias{brier}
\alias{cindex}
\alias{cross_entropy}
\alias{f_score}
\alias{fnr}
\alias{fpr}
\alias{kappa2}
\alias{npv}
\alias{ppv}
\alias{pr_auc}
\alias{precision}
\alias{recall}
\alias{roc_auc}
\alias{roc_index}
\alias{rpp}
\alias{sensitivity}
\alias{specificity}
\alias{tnr}
\alias{tpr}
\alias{weighted_kappa2}
\alias{gini}
\alias{mae}
\alias{mse}
\alias{msle}
\alias{r2}
\alias{rmse}
\alias{rmsle}
\title{Performance Metrics}
\usage{
accuracy(observed, predicted = NULL, cutoff = 0.5, ...)

auc(observed, predicted = NULL, metrics = c(MachineShop::tpr,
  MachineShop::fpr), stat = base::mean, ...)

brier(observed, predicted = NULL, ...)

cindex(observed, predicted = NULL, ...)

cross_entropy(observed, predicted = NULL, ...)

f_score(observed, predicted = NULL, cutoff = 0.5, beta = 1, ...)

fnr(observed, predicted = NULL, cutoff = 0.5, ...)

fpr(observed, predicted = NULL, cutoff = 0.5, ...)

kappa2(observed, predicted = NULL, cutoff = 0.5, ...)

npv(observed, predicted = NULL, cutoff = 0.5, ...)

ppv(observed, predicted = NULL, cutoff = 0.5, ...)

pr_auc(observed, predicted = NULL, ...)

precision(observed, predicted = NULL, cutoff = 0.5, ...)

recall(observed, predicted = NULL, cutoff = 0.5, ...)

roc_auc(observed, predicted = NULL, ...)

roc_index(observed, predicted = NULL, cutoff = 0.5,
  f = function(sensitivity, specificity) (sensitivity + specificity)/2,
  ...)

rpp(observed, predicted = NULL, cutoff = 0.5, ...)

sensitivity(observed, predicted = NULL, cutoff = 0.5, ...)

specificity(observed, predicted = NULL, cutoff = 0.5, ...)

tnr(observed, predicted = NULL, cutoff = 0.5, ...)

tpr(observed, predicted = NULL, cutoff = 0.5, ...)

weighted_kappa2(observed, predicted = NULL, power = 1, ...)

gini(observed, predicted = NULL, ...)

mae(observed, predicted = NULL, ...)

mse(observed, predicted = NULL, ...)

msle(observed, predicted = NULL, ...)

r2(observed, predicted = NULL, ...)

rmse(observed, predicted = NULL, ...)

rmsle(observed, predicted = NULL, ...)
}
\arguments{
\item{observed}{observed responses, \code{\link{Curves}} object, or
\code{\link[=confusion]{ConfusionMatrix}} of observed and predicted
responses.}

\item{predicted}{predicted responses.}

\item{cutoff}{threshold above which binary factor probabilities are
classified as events and below which survival probabilities are classified.}

\item{...}{arguments passed to or from other methods.}

\item{metrics}{list of two performance metrics for the calculation [default:
ROC metrics].}

\item{stat}{function to compute a summary statistic at each cutoff value of
resampled metrics in \code{Curves}, or \code{NULL} for resample-specific
metrics.}

\item{beta}{relative importance of recall to precision in the calculation of
\code{f_score} [default: F1 score].}

\item{f}{function to calculate a desired sensitivity-specificity tradeoff.}

\item{power}{power to which positional distances of off-diagonals from the
main diagonal in confusion matrices are raised to calculate
\code{weighted_kappa2}.}
}
\description{
Compute measures of agreement between observed and predicted responses.
}
\seealso{
\code{\link{metricinfo}}, \code{\link{confusion}},
\code{\link{performance}}, \code{\link{performance_curve}}
}
